# jedit_checkpoint.tcl - undo and redo support for jedit
# 
# Copyright 1992-1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for non-profit, noncommercial use.

######################################################################
# save current state in undo ring
#   { t args } lets it be used with j:tkb:mkmap
######################################################################

proc jedit:cmd:save_checkpoint { t args } {
  global CKPT_TEXT CKPT_ANNO JEDIT_PREFS UNDOPTR

  if $JEDIT_PREFS(undolevels) {
    set CKPT_TEXT($UNDOPTR) [$t get 1.0 end]
    set CKPT_ANNO($UNDOPTR) [j:tag:get_annotation $t]
    incr UNDOPTR
    set old [expr {$UNDOPTR - $JEDIT_PREFS(undolevels)}]
    catch {
      unset CKPT_TEXT($old)			;# forget a previous checkpoint
      unset CKPT_ANNO($old)
    }
  } else {
    j:alert -text "You don't have undo turned on."
  }
}

######################################################################
# jedit:cmd:undo - restore from saved state (moving backwards in undo ring)
#   { t args } lets it be used with j:tkb:mkmap
######################################################################

proc jedit:cmd:undo { t args } {
  global CKPT_TEXT CKPT_ANNO JEDIT_PREFS UNDOPTR

  if $JEDIT_PREFS(undolevels) {
    set CKPT_TEXT($UNDOPTR) [$t get 1.0 end]
    set CKPT_ANNO($UNDOPTR) [j:tag:get_annotation $t]
    incr UNDOPTR -1
    if {![info exists CKPT_TEXT($UNDOPTR)]} {
      incr UNDOPTR
      j:alert -text "No more undo information available."
    }
    $t delete 1.0 end
    $t insert end $CKPT_TEXT($UNDOPTR)
    j:tag:set_annotation $t $CKPT_ANNO($UNDOPTR)
    $t yview -pickplace insert
  } else {
    j:alert -text "You aren't saving any undo information."
  }
}

######################################################################
# restore from saved state (moving forwards in undo ring)
#   { t args } lets it be used with j:tkb:mkmap
######################################################################

proc jedit:cmd:redo { t args } {
  global CKPT_TEXT CKPT_ANNO JEDIT_PREFS UNDOPTR

  if $JEDIT_PREFS(undolevels) {
    set CKPT_TEXT($UNDOPTR) [$t get 1.0 end]
    set CKPT_ANNO($UNDOPTR) [j:tag:get_annotation $t]
    incr UNDOPTR
    if {![info exists CKPT_TEXT($UNDOPTR)]} {
      incr UNDOPTR -1
      j:alert -text "No more redo information available."
    }
    $t delete 1.0 end
    $t insert end $CKPT_TEXT($UNDOPTR)
    j:tag:set_annotation $t $CKPT_ANNO($UNDOPTR)
    $t yview -pickplace insert
  } else {
    j:alert -text "You aren't saving any undo information."
  }
}
