# jdoc_cmds.tcl - command procedures for jdoc
# 
# Copyright 1992-1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for non-profit, noncommercial use.

##############################################################################
# jdoc:cmd:about - make the about box
##############################################################################

proc jdoc:cmd:about {} {
  global VERSION
  set about_help [format {
    j:rt:hl "jdoc"
    j:rt:cr
    j:rt:rm "by Jay Sekora, "
    j:rt:tt "js@bu.edu"
    j:rt:par
    j:rt:rm "An X Windows application for viewing help files."
    j:rt:cr
    j:rt:rm "Version %s."
    j:rt:par
    j:rt:rm "Copyright \251 1992-1994 by Jay Sekora.  "
    j:rt:rm "All rights reserved, except that this file may be freely "
    j:rt:rm "redistributed in whole or in part for non\255profit, "
    j:rt:rm "noncommercial use."
    j:rt:par
    j:rt:rm "If you find bugs or have suggestions for improvement, "
    j:rt:rm "please let me know.  "
    j:rt:rm "Feel free to use bits of this code in your own "
    j:rt:tt "wish"
    j:rt:rm " scripts."
  } $VERSION]
  j:about .about $about_help
  j:about:button .about {About jdoc} $about_help
  j:about:button .about {About the Author} [j:about_jay]
  j:about:button .about {About Tk and Tcl} [j:about_tktcl]
  
  tkwait window .about
}

##############################################################################
# jdoc:cmd:help - get help on jdoc
##############################################################################

proc jdoc:cmd:help {} {
  exec jdoc jdoc &
}

##############################################################################
# jdoc:cmd:doc_prefs - preferences panel
##############################################################################

proc jdoc:cmd:doc_prefs {} {
  global JDOC_PREFS
  
  set w .doc_prefs
  toplevel $w
  wm title $w "Help Viewer Preferences"

  frame $w.size
  label $w.size.wl -text {Width:}
  entry $w.size.we -relief sunken -width 3 \
    -textvariable JDOC_PREFS(textwidth)
  label $w.size.hl -text {Height:}
  entry $w.size.he -relief sunken -width 3 \
    -textvariable JDOC_PREFS(textheight)

  j:colour_chooser $w.textbg -variable JDOC_PREFS(textbg) \
    -label "Normal Background:"
  j:colour_chooser $w.textfg -variable JDOC_PREFS(textfg) \
    -label "Normal Foreground:"
  j:colour_chooser $w.textsb -variable JDOC_PREFS(textsb) \
    -label "Selected Background:"
  j:colour_chooser $w.textsf -variable JDOC_PREFS(textsf) \
    -label "Selected Foreground:"
  
  label $w.textsbw-label -text "Selection Border Width:" -anchor w
  scale $w.textsbw -from 0 -to 25  -orient horizontal \
    -command {set JDOC_PREFS(textsbw)}
  $w.textsbw set $JDOC_PREFS(textsbw)
  
  label $w.textbw-label -text "Text Border Width:" -anchor w
  scale $w.textbw -from 0 -to 50  -orient horizontal \
    -command {set JDOC_PREFS(textbw)}
  $w.textbw set $JDOC_PREFS(textbw)
  
  j:buttonbar $w.b -default save -buttons [format {
    { 
      save Save {
        jdoc:configure_text .t
        j:write_prefs -array JDOC_PREFS -file jdoc-defaults
        destroy %s
      }
    } {
      done Done {
        jdoc:configure_text .t
        destroy %s
      }
    }
  } $w $w]
  
  pack $w.size.wl $w.size.we [j:filler $w.size] $w.size.hl $w.size.he \
    -in $w.size -side left

  pack \
    $w.size \
    [j:rule $w] \
    $w.textbg \
    [j:rule $w] \
    $w.textfg \
    [j:rule $w] \
    $w.textsb \
    [j:rule $w] \
    $w.textsf \
    [j:rule $w] \
    $w.textsbw-label $w.textsbw \
    [j:filler $w] \
    $w.textbw-label $w.textbw \
    [j:rule $w] \
    $w.b \
    -in $w -side top -fill x

  j:dialogue $w		;# position in centre of screen

  focus $w
  j:default_button $w.b.save $w.size.we $w.size.he $w
  j:tab_ring $w.size.we $w.size.he
  bind $w <Key-Tab> "focus $w.size.we"
}

##############################################################################
# jdoc:cmd:quit - quit
##############################################################################

### THIS CURRENTLY ISN'T USED

proc jdoc:cmd:quit {} {
  if [j:confirm -text "Are you sure you want to quit?"] {
    exit 0
  }
}

##############################################################################
# jdoc:cmd:load - prompt user to select topic from a list
##############################################################################

proc jdoc:cmd:load {} {
  global JDOC_PREFS JDOC_PATH JDOC_TOPIC
  
  if [winfo exists .topics] {destroy .topics}
  toplevel .topics
  label .topics.l -text "Double\255click on a topic:"
  listbox .topics.lb -relief flat \
    -yscroll {.topics.sb set} -exportselection false
  j:tk3 {.topics.lb configure -geometry 30x20}
  j:tk4 {.topics.lb configure -width 30 -height 20}
  scrollbar .topics.sb -command {.topics.lb yview}
  button .topics.ok -width 10 -text OK -command {
    set JDOC_TOPIC [.topics.lb get [lindex [.topics.lb curselection] 0]]
    destroy .topics
  }
  pack append .topics \
    .topics.ok {bottom pady 5 padx 5} \
    [j:rule .topics] {bottom fillx} \
    .topics.l {top fillx pady 10} \
    [j:rule .topics] {top fillx} \
    .topics.lb {left expand fill} \
    [j:rule .topics] {left filly} \
    .topics.sb {left filly}

  set topics {}
  
  foreach dir $JDOC_PATH {
    foreach file [glob -nocomplain $dir/*.jdoc] {
      set topic [file rootname [file tail $file]]
      if {[lsearch -exact $topics $topic] == -1} {
        lappend topics $topic
      }
    }
  }
  if {"x$topics" == "x"} {
    j:alert -text "Unable to find any help files."
    destroy .topics
    return
  }
  foreach topic [lsort $topics] {
    .topics.lb insert end $topic
  }
  bind .topics.lb <Double-Button-1> {
    set JDOC_TOPIC [.topics.lb get [lindex [.topics.lb curselection] 0]]
    destroy .topics
  }
  bind .topics.lb <Button-3> [bind .topics.lb <Double-Button-1>]
  j:dialogue .topics
  tkwait window .topics
  jdoc:load_topic $JDOC_TOPIC
}

######################################################################
# jdoc:cmd:print_postscript - print rich-text as postscript using lpr
######################################################################

proc jdoc:cmd:print_postscript {} {
  global J_PREFS
  if [j:confirm -priority 24 \
    -text "Print as PostScript using `lpr' to printer `$J_PREFS(printer)'?"] {
    exec lpr -P$J_PREFS(printer) << [j:tc:ps:convert_text .t]
  }
}
