# jbindentry.tcl - support for Entry bindings
# 
# Copyright 1992-1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for non-profit, noncommercial use.

######################################################################
# j:selection_if_any - return selection if it exists, else {}
#   this is from kjx@comp.vuw.ac.nz (R. James Noble)
#   defined elsewhere, but copied here so the bindings libraries
#   don't depend on jtkutils
######################################################################

if {[info procs j:selection_if_any] == {}} {
  proc j:selection_if_any {} {
    if {[catch {selection get} s]} {return ""} {return $s}
  }
}

######################################################################
# j:eb:init - initialise info for bindings
######################################################################

proc j:eb:init { {e Entry} } {
  global J_PREFS env
  if {! [info exists J_PREFS(typeover)]} {set J_PREFS(typeover) 1}
  switch -exact $J_PREFS(bindings) {
    basic {
      j:eb:basic_init $e
    }
    emacs {
      j:eb:emacs_init $e
    }
    edt {
      j:eb:edt_init $e
    }
    vi {
      j:eb:vi_init $e
    }
  }

  # read in user's supplementary entry bindings
  j:source_config entrybindings.tcl
}

######################################################################
# j:eb:no_op - do nothing
######################################################################

proc j:eb:no_op { args } {
  return 0
}

######################################################################
# j:eb:beep W - beep
######################################################################

proc j:eb:beep { W args } {
  j:beep $W
  return 0
}

######################################################################
# j:eb:clear_selection W - clear the selection in widget W
######################################################################

proc j:eb:clear_selection { W args } {
  $W select clear
}

######################################################################
# j:eb:select_all W - select all text in widget W
######################################################################

proc j:eb:select_all { W args } {
  $W select from 0
  $W select to end
}

######################################################################
# j:eb:is_bol W - return true if insert is at beginning of line
#   from Achim Bonet <ach@.....>
######################################################################

proc j:eb:is_bol { W } {
  return [expr {!([$W index insert])}]
}

######################################################################
# j:eb:is_eol W - return true if insert is at end of line
#   from Achim Bonet <ach@.....>
######################################################################

proc j:eb:is_eol { W } {
  return [expr {!([$W index end]-[$W index insert])}]
}

######################################################################
###  GENERAL ENTRY ROUTINE (can be used as key or mouse binding)
######################################################################

# j:eb:paste_selection W - insert the X selection in an entry
proc j:eb:paste_selection { W args } {
  $W insert insert [string trim [j:selection_if_any] "\n\r"]
  tk_entrySeeCaret $W
}

######################################################################
######################################################################
### ROUTINES TO SET UP ENTRY BINDINGS

# j:eb:key_bind W args - set up bindings to process keys
proc j:eb:key_bind { W args } {
  # get rid of a few default Tk bindings:
  foreach binding {
    <Any-Key> <Any-Key> <Control-Key-d> <Control-Key-h> <Control-Key-u>
    <Control-Key-v> <Control-Key-w> <Control-Key> <Key-BackSpace>
    <Key-Delete> <Key-Return> <Key> <Shift-Key>
  } {
    bind $W $binding {}
  }
  # and create null bindings for modifiers, so they don't trigger commands:
  foreach binding {
    <Shift_L> <Shift_R> <Control_L> <Control_R> <Caps_Lock>
    <Shift_Lock> <Meta_L> <Meta_R> <Alt_L> <Alt_R>
  } {
    bind $W $binding { }
  }
  
  bind $W <Key>			{j:ekb:process_key %W "" %K %A}
  bind $W <Shift-Key>		{j:ekb:process_key %W "" %K %A}
  bind $W <Control-Key>		{j:ekb:process_key %W Control %K %A}
  
  # Compose (Multi_key) key support:
  bind $W <Multi_key>		{ }
  bind $W <Multi_key><Any-Key>	{j:ec:start_sequence %W %K %A}
  bind $W <Multi_key><Any-Key><Any-Key> \
  				{j:ec:finish_sequence %W %K %A}
  bind $W <Multi_key><Any-KeyRelease><Any-Key> \
    				{j:ec:start_sequence %W %K %A}
  bind $W <Multi_key><Any-Key><Any-Key> \
  				{j:ec:finish_sequence %W %K %A}
  bind $W <Multi_key><Any-Key><Any-KeyRelease><Any-Key> \
  				{j:ec:finish_sequence %W %K %A}
  bind $W <Multi_key><Any-KeyRelease><Any-Key><Any-KeyRelease><Any-Key> \
  				{j:ec:finish_sequence %W %K %A}
}

