# jalert.tcl - notification panel
# 
# Copyright 1992-1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for non-profit, noncommercial use.

######################################################################
# j:alert ?options? - alert box
# options include
#   -title (default "Alert")
#   -text (default "Alert!" - not really optional)
######################################################################

proc j:alert { args } {
  j:parse_args {
    {title "Alert"}
    {text "Alert!"}
  }
  set old_focus [j:current_focus]	;# so we can restore original focus
  toplevel .alert
  wm title .alert $title
  
  message .alert.msg -width 300 -anchor w -text $text
  j:buttonbar .alert.b -default ok -buttons {{ok OK {destroy .alert}}}
  
  pack .alert.msg -side top -fill both -expand yes -padx 10 -pady 10
  pack [j:rule .alert -width 200] -side top -fill x
  pack .alert.b -side bottom -fill both
  
  j:dialogue .alert		;# position in centre of screen

  focus .alert
  j:default_button .alert.b.ok .alert
  grab .alert
  tkwait window .alert
  focus $old_focus
}
