
proc RoloLoadFile {File w} {
    set Records ""
    if { ![file exists $File] && ![regexp {^|} $File] } {
        set fdFile [open $File "w"]
        puts $fdFile "#Name:Address1::Address2::Phone Home:Work:FAX:Pager:email:::"
        close $fdFile
    }

    set fdFile [open $File "r"]

    set line [gets $fdFile]
    if {[regexp {^#} $line]} {
        set FieldNames [split $line ":"]
	set nRecords 0
    } else {
	set FieldNames ""
	set temp [split $line ":"]
        set Records [list $temp]
	set nRecords 1
	set n 0
	foreach i $temp { 
	    lappend FieldNames "Field $n"
	    set n [expr "$n + 1"]
	}
    }

    set n 0
    foreach i $FieldNames {
        if { $n == 0 } {
            regexp {[^#].*} $i i
        }
        frame "$w.$n"
        pack append $w $w.$n top
        label "$w.$n.label" -width 15 -text $i  -anchor e
        entry "$w.$n.entry" -exportselection true  -width 30 -relief sunken
	bind $w.$n.entry <Tab>  "focus $w.[expr "$n + 1"].entry"
        pack append $w.$n $w.$n.entry right $w.$n.label right
        set n [expr "$n + 1"]
    }
    bind $w.[expr "$n - 1"].entry <Tab>  "focus $w.0.entry"
    focus $w.0.entry

    set nfields [expr "$n - 1"]
    while {! [eof $fdFile]} {
        set line [gets $fdFile]
        if { $line != "" } {
            lappend Records [split $line {:}]
	    incr nRecords
        }
    }
    close $fdFile
    set Records [lsort $Records]
    return [list $Records $FieldNames $nRecords]
}

proc RoloSaveFile { File FieldNames Records } {
    set fdFile [open $File "w"]
    puts $fdFile [join $FieldNames ":"]
    set len [llength $Records]
    foreach record $Records {
        set line [join $record ":"]
        if { $line != "" } {
            puts $fdFile $line
        }
    }
    close $fdFile
}

proc RoloShowCurrent {w record nfields} {
    set found 0
    for  {set i 0} {$i < $nfields} {incr i} {
        $w.$i.entry delete 0 1000
        set field [lindex $record $i]
        $w.$i.entry insert 0 $field
        regexp {[A-Za-z&. ]*} $field field
    }
}

proc RoloGetRecord {w nfields} {
    set result ""
    for  {set i 0} {$i < $nfields} {incr i} {
        set result [linsert $result $i [$w.$i.entry  get] ]
    }
    return $result
}
    
proc Rolodex { File } {

    set w ".rolo[getid]"

    global current nfields Records FieldNames Filenames

    toplevel $w
    wm title $w "Rolodex $File"

    set current($w) 0
    set nfields($w) 0

    frame $w.record -relief raised -border 2
    frame $w.file -relief raised -border 2
    frame $w.screen -relief raised -border 2
    pack append $w $w.screen {top filly frame center}
    pack append $w $w.record {left}
    pack append $w $w.file {right}

    set res [RoloLoadFile $File $w.screen]
    set Filenames($w) $File
    set Records($w) [lindex $res 0]
    set FieldNames($w) [lindex $res 1]
    set nfields($w) [llength $FieldNames($w)]
    set nRecords($w) [lindex $res 2]

    RoloShowCurrent $w.screen [lindex $Records($w) $current($w)] $nfields($w)

    label $w.record.title -text "Record"
    button $w.record.next -text Next -command "RoloNext $w"
    button $w.record.prev -text Prev -command "RoloPrev $w"
    button $w.record.new -text New -command "RoloNew $w"
    button $w.record.copy -text Copy -command "RoloCopy $w"
    button $w.record.chg -text Change -command "RoloChange $w"
    button $w.record.delete -text "Delete" -command "RoloDelete $w"
    label $w.file.title -text "File"
    button $w.file.search -text "Search" -command "RoloSearch $w"
    button $w.file.save -text "Save" -command "RoloSave $w"
    button $w.file.quit -text "Close" -command "RoloClean $w"
    pack append $w.record \
        $w.record.title {top} \
        $w.record.next {left padx 4} \
        $w.record.prev {left padx 4} \
        $w.record.new {left padx 4} \
        $w.record.copy {left padx 4} \
        $w.record.chg {left padx 4} \
        $w.record.delete {left padx 4}
    pack append $w.file \
        $w.file.title {top} \
        $w.file.search {left padx 4} \
        $w.file.save {left padx 4} \
        $w.file.quit {left padx 4}
}
proc RoloClean {w} {
    destroy $w
    set Filenames($w) ""
    set Records($w) ""
    set FieldNames($w) ""
    set nfields($w) ""
}
proc RoloSave {w} {
    global current nfields Records FieldNames Filenames
    RoloSaveFile $Filenames($w) $FieldNames($w) $Records($w)
}
proc RoloDelete {w} {
    global current nfields Records FieldNames
    if { [rusure "Really delete?"] == 1 } {
	set Records($w) [lreplace $Records($w) $current($w) $current($w)]
	RoloShowCurrent $w.screen [lindex $Records($w) $current($w)] $nfields($w)
    }
}
proc rusure {message} {
    global response

    set p .rusure;
    toplevel $p -relief raised
    wm focus $p active
    set response 0
    label $p.label -text "$message"
    button $p.yes -relief raised -text "Ok" -command "set response 1; destroy $p"
    button $p.no -relief raised -text "Cancel" -command "set response 0; destroy $p"
    pack append $p $p.label {top}  $p.yes {left} $p.no {right}

    tkwait variable response
    return $response
}
    
proc RoloSearch {w} {
    global current nfields Records FieldNames Filenames lastfound
    set p ".pop[getid]"
    toplevel $p -relief raised
    wm focus $p active 

    set lastfound($w) -1
    label $p.label -text "Search in $Filenames($w)"
    entry $p.entry -exportselection true -width 20 -relief sunken
    button $p.ok -text "Find Next" -command "RoloSubSearch $w $p"
    focus $p.entry
    
    button $p.cancel -text "Cancel" -command "destroy $p"
    pack append $p \
	$p.label {top}     \
	$p.entry {top}        \
	$p.ok {bottom left}    \
	$p.cancel {bottom right}
}

proc RoloSubSearch {w p} {
    global current nfields Records FieldNames lastfound
    set search [$p.entry get]
    set current($w) 0
    foreach record $Records($w) {
        set line [join $record ":"]
	if { [regexp $search $line] && ($current($w) > $lastfound($w)) } {
	    RoloShowCurrent $w.screen $record $nfields($w)
	    set lastfound($w) $current($w)
	    return
	}
        incr current($w)
    }
    set lastfound($w) -1
}

proc RoloChange {w} {
    global current nfields Records FieldNames
    set Records($w) [lreplace $Records($w) $current($w) $current($w)]
    set Records($w) [linsert $Records($w) 0 [RoloGetRecord $w.screen $nfields($w)]]
    set Records($w) [lsort $Records($w)]
    RoloShowCurrent $w.screen [lindex $Records($w) $current($w)] $nfields($w)
}
proc RoloNew {w} {
    global current nfields Records FieldNames
    set current($w) $nRecords($w)
    incr nRecords($w)
}
proc RoloCopy {w} {
    global current nfields Records FieldNames
    set Records($w) [linsert $Records($w) 0 [RoloGetRecord $w.screen $nfields($w)]]
    set Records($w) [lsort $Records($w)]
    RoloShowCurrent $w.screen [lindex $Records($w) $current($w)] $nfields($w)
}
proc RoloPrev {w} { 
    global current nfields Records FieldNames
    set current($w) [expr "$current($w) - 1"]
    RoloShowCurrent $w.screen [lindex $Records($w) $current($w)] $nfields($w)
}
proc RoloNext {w} { 
    global current nfields Records FieldNames
    set current($w) [expr "$current($w) + 1"]
    RoloShowCurrent $w.screen [lindex $Records($w) $current($w)] $nfields($w)
}

set topid 0

proc getid {} {
    global topid
    incr topid
    return $topid
}
