/*
 * logg.c:
 * (schoenfr@ibr.cs.tu-bs.de)
 *
 * choco to schoenfr, flames to /dev/null
 *
 * (used only internally to test syslogd)
 *
 * use: logg  [port@]<host>  '<message to sent>'
 * eg:  logg /dev/log@localhost 'hi ho'
 *      logg 514@amalthea.ibr.cs.tu-bs.de 'greetings'
 *
 * compile with ``make logg'' or ``cc -o logg logg.c''
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/un.h>
#include <netdb.h>


bye (s) char *s; { perror (s); exit (1); }

int
main (argc, argv)
char *argv[];
{
    struct sockaddr_in in_maddr, daddr;
    struct sockaddr_un un_maddr;
    struct hostent *he;
    char *portname, *hostname, *ptr;
    int s;
    
    if (argc != 3)
    {
	fputs ("\nuse: logg  [port@]<host>  '<message to sent>'\n", stderr);
	fputs ("eg:  logg amalthea.ibr.cs.tu-bs.de \"hi nase: greetings from `who am i`\"\n\n", stderr);
	exit (1);
    }
    
    if ((ptr = strchr (argv[1], '@')))
    {
	portname = argv [1];
	*ptr = 0;
	hostname = ptr + 1;
    }
    else {
	portname = "514";
	hostname = argv [1];
    }    

    if (*portname == '/')
    {
	/* talk to unix-domain socket: */

	if (strcmp (hostname, "localhost"))
	    fprintf (stderr, "* host `%s' ignored - localhost used...\n", 
		     hostname);

	if ((s = socket (AF_UNIX, SOCK_DGRAM, 0)) < 0)
	    bye ("socket");
	
	un_maddr.sun_family = AF_UNIX;
	strcpy (un_maddr.sun_path, portname);
	
	if (connect(s, (struct sockaddr *) &un_maddr, sizeof un_maddr) < 0)
	    bye ("connect");
	
	if (send (s, argv [2], strlen (argv [2]), 0) < 0)
	    bye ("sendto");
    }
    else {
	/* talk to inet domain socket: */

	if ((s = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
	    bye ("socket");
	
	in_maddr.sin_family = AF_INET;
	in_maddr.sin_port = 0;
	in_maddr.sin_addr.s_addr = INADDR_ANY;
	
	if (bind (s, (struct sockaddr *) &in_maddr, sizeof in_maddr) < 0)
	    bye ("bind");
    
	if (! (he = gethostbyname (hostname)))
	    bye ("gethostbyname");
    
	daddr.sin_family = AF_INET;
	daddr.sin_addr = * ((struct in_addr *) he->h_addr);
	daddr.sin_port = htons (atoi (portname));
	
	if (sendto (s, argv [2], strlen (argv [2]), 0,
		    (struct sockaddr *) & daddr, sizeof daddr) < 0)
	    bye ("sendto");
    }

    return 0;
}
