/*
 * xmalloc.c
 *
 * A fail-save malloc, realloc and strdup.
 *
 * Copyright (c) 1994
 *
 * J. Schoenwaelder
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#include <string.h>

#ifndef DBMALLOC

#include <tcl.h>
#include "xmalloc.h"

char*
xmalloc (size)
    unsigned size;
{
    char *mem;

    for (;;) 
    {
	mem = (char *) malloc(size);
	if (mem) break;
	sleep (1);
    }
    
    return mem;
}

/*
 * A fail-save realloc.
 */

char*
xrealloc (ptr, size)
    char *ptr;
    unsigned size;
{
    char *mem;
    
    if (!ptr) 
	    mem = (char *) xmalloc(size);
    else
	    for (;;) 
	    {
		mem = (char *) realloc(ptr, size);
		if (mem) break;
		sleep (1);
	    }
    
    return mem;
}

/*
 * We define our own strdup since some systems don't have it.
 */

char* 
xstrdup(s) 
    char *s;
{
    char *ns = xmalloc(strlen(s)+1);
    return strcpy(ns, s);
}
#endif

