/*
 * oid.h
 *
 * Some small utilities that deal with object identifier.
 *
 * Copyright (c) 1994
 *
 * Sven Schmidt, J. Schoenwaelder
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

/*
 * The maximum length of an object identifier is 128 (see RFC 1448).
 * Object identifier are represented as a vector of unsigned int.
 */

#define OID_MAXLEN 128

typedef u_int oid;

/*
 * Functions to manipulate object identifier.
 */

char*
SNMP_Oid2Str	_ANSI_ARGS_((oid *objid, int len));

oid*
SNMP_Str2Oid	_ANSI_ARGS_((char *str, int *len));

oid*
SNMP_OidDup	_ANSI_ARGS_((int *buflen, oid *Oid, int OidLen));

int
SNMP_IsOid	_ANSI_ARGS_((char *str));


