/*
 * memory.h
 *
 * These functions simplify the memory management. They allocate and
 * free SNMP structures and take care to initialize them appropriate.
 *
 * Copyright (c) 1994
 *
 * Sven Schmidt, J. Schoenwaelder
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

/*
 * Allocate and free a session structure.
 */

struct session*
SNMP_MallocSession	_ANSI_ARGS_((int *sid));

void
SNMP_FreeSession	_ANSI_ARGS_((struct session *session));

/*
 * Allocate and free a request structure.
 */

struct request_list*
SNMP_MallocRequest	_ANSI_ARGS_((void));

void
SNMP_FreeRequest	_ANSI_ARGS_((struct request_list *request));
