/*
 * asn1.h
 *
 * Copyright (c) 1994
 *
 * Sven Schmidt
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

/*
 * Definition of ASN1 data types used for SNMP.
 */

#define UNIVERSAL		( 0x00 )
#define APPLICATION		( 0x40 )
#define CONTEXT_SPECIFIC	( 0x80 )
#define PRIVATE			( 0xc0 )

#define PRIMITIVE		( 0x00 )
#define CONSTRUCTED		( 0x20 )

#define TAG_0			( 0x00 )
#define TAG_1			( 0x01 )
#define TAG_2			( 0x02 )
#define TAG_3			( 0x03 )
#define TAG_4			( 0x04 )
#define TAG_5			( 0x05 )
#define TAG_6			( 0x06 )
#define TAG_7			( 0x07 )
#define TAG_8			( 0x08 )

#define BIT_8			( 0x80 )

#define	ASN1_INTEGER		( 0x02 )
#define ASN1_BIT_STRING		( 0x03 )
#define	ASN1_OCTET_STRING	( 0x04 )
#define	ASN1_NULL		( 0x05 )
#define ASN1_OBJECT_IDENTIFIER	( 0x06 )
#define ASN1_SEQUENCE		( 0x10 )

#define ASN1_IpAddress		( APPLICATION | PRIMITIVE | TAG_0 )
#define ASN1_Counter		( APPLICATION | PRIMITIVE | TAG_1 )
#define ASN1_Gauge		( APPLICATION | PRIMITIVE | TAG_2 )
#define ASN1_TimeTicks		( APPLICATION | PRIMITIVE | TAG_3 )
#define ASN1_Opaque		( APPLICATION | PRIMITIVE | TAG_4 )
#define ASN1_NsapAddress	( APPLICATION | PRIMITIVE | TAG_5 )
#define ASN1_Counter64		( APPLICATION | PRIMITIVE | TAG_6 )
#define ASN1_UInteger32		( APPLICATION | PRIMITIVE | TAG_7 )

/*
 * Non-aggregate types for MIB tree nodes that are not defined in SMI or
 * to distinguish from their SNMPV1 values
 */

#define	ASN1_OTHER		( 0x00 )
#define	SEQUENCE_OF		( 0x11 )
#define Integer32		( 0x14 )
#define	NetworkAddress		( 0x15 )
#define	Counter32		( 0x16 )
#define Gauge32			( 0x17 )
#define	DisplayString		( 0x18 )
#define	PhysAddress		( 0x19 )
#define	OwnerString		( 0x1A )
#define	EntryStatus		( 0x1B )
#define	Party			( 0x1C )
#define ASN1_TAddress		( 0x1D )

/*
 * Convert syntax names into the internal representation and back.
 */

int
ASN1_Str2Sntx		_ANSI_ARGS_(( char *str ));

char*
ASN1_Sntx2Str		_ANSI_ARGS_(( int sntx ));

/*
 * This function return a static error string describing the last error.
 */

char*
ASN1_ErrorString	_ANSI_ARGS_((void));

/*
 * Functions visible for other modules (encoding/decoding)
 */

u_char*
ASN1_EncodeLength	_ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_char *len_fld, int length));
u_char*
ASN1_DecodeLength	_ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_int *length));
u_char*
ASN1_EncodeInt		_ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_char type, int value));
u_char*
ASN1_DecodeInt		_ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_char type, int *value));
u_char*
ASN1_EncodeOID		_ANSI_ARGS_((u_char *packet, int *packetlen,
				     oid *objid, int oidlen));
u_char*
ASN1_DecodeOID		_ANSI_ARGS_((u_char *packet, int *packetlen,
				     oid *objid, int *oidlen));
u_char*
ASN1_EncodeOctetString	_ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_char type, u_char *octets, int len));
u_char*
ASN1_DecodeOctetString	_ANSI_ARGS_((u_char *packet, int *packetlen,
				     u_char type, u_char **octets, int *len));
u_char*
ASN1_EncodeNull		_ANSI_ARGS_((u_char *packet, int *packetlen));


