/*
 * snmp_agent.h
 *
 * Definitions for the the SNMP agent interface of scotty.
 *
 * Copyright (c) 1994
 *
 * J. Schoenwaelder
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

struct instance {
    char *label;
    u_int subid;
    char *syntax;
    int access;
    char *tclvar;
    struct instance *child;
    struct instance *next;
};

extern int
SNMP_CreateInstance	_ANSI_ARGS_((Tcl_Interp *interp,
				     char *id, char *varname, char *defval));

extern void
SNMP_AgentInit		_ANSI_ARGS_((Tcl_Interp *interp));

extern int
SNMP_AgentRequest	_ANSI_ARGS_((Tcl_Interp *interp, 
				     struct session *session,
				     struct snmp_pdu *pdu));

