/*
 * scotty.h
 *
 * Common definitions for the scotty extensions to tcl.
 *
 * Copyright (c) 1993, 1994
 *
 * J. Schoenwaelder
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include <tcl.h>

#define SCOTTY_VERSION "1.2.0"

/*
 * This is the scotty initialization function that may be used
 * to extend other tcl interpreter.
 */

extern int Scotty_Init _ANSI_ARGS_((Tcl_Interp *interp));

/*
 * The command extensions provided by scotty.
 */

extern int  getdateCmd     _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  getclockCmd    _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  sleepCmd       _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  nslookCmd      _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  afterCmd       _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  addInputCmd    _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  remInputCmd    _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  jobCmd         _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  syslogCmd      _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  udpCmd         _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  tcpCmd         _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  Tcl_SelectCmd  _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  rpcCmd         _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  httpCmd        _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  funcCmd        _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  dnsCmd         _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  ntpCmd         _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  sunrpcCmd      _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern int  icmpCmd        _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));
extern void icmpClose      _ANSI_ARGS_((void));

extern int  inedCmd        _ANSI_ARGS_((ClientData clientData, 
			      Tcl_Interp *interp, int argc, char **argv));

/*
 * flush the ined queue and start scotty's ugly event loop.
 */

extern void inedFlush      _ANSI_ARGS_((Tcl_Interp *));

extern void eventLoop      _ANSI_ARGS_((Tcl_Interp *interp));

/*
 * The SNMP package and the optional BONES extension provide their
 * own initialization procedure. We define them here to bypass any
 * problems with finding their include files.
 */

extern int SNMP_Init      _ANSI_ARGS_((Tcl_Interp *interp));

#ifdef HAVE_BONES
extern int Bones_Init     _ANSI_ARGS_((Tcl_Interp *interp));
#endif

#ifdef HAVE_OSIMIS
extern int CMIP_Init	  _ANSI_ARGS_((Tcl_Interp *interp));
#endif

/*
 * These are the definitions found in the TK library and reprogrammed
 * in event.c. They will be replaced by the TK versions once TK 4.0
 * comes out. John Ousterhout announced that the event loop of TK will
 * be usable without any further access to the X11 server.
 */

#define TK_READABLE	1    /* Corresponding to the tk definition */
#define TK_WRITABLE	2    /* Corresponding to the tk definition */
#define TK_EXCEPTION	4    /* Corresponding to the tk definition */

typedef void (Tk_FileProc)  _ANSI_ARGS_((ClientData clientData, int mask));
typedef void (Tk_TimerProc) _ANSI_ARGS_((ClientData clientData));

typedef struct Tk_TimerToken_ *Tk_TimerToken;

extern Tk_TimerToken    Tk_CreateTimerHandler _ANSI_ARGS_((int milliseconds,
			    Tk_TimerProc *proc, ClientData clientData));
extern void             Tk_DeleteTimerHandler _ANSI_ARGS_((
                            Tk_TimerToken token));
extern void             Tk_CreateFileHandler _ANSI_ARGS_((int fd, int mask,
			    Tk_FileProc *proc, ClientData clientData));
extern void		Tk_DeleteFileHandler _ANSI_ARGS_((int fd));

