/*
 * eventRep.c 
 *
 * Copyright (c) 1994
 *
 * M. Kernchen
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include "cmip.h"

int
cmip_eventReport(clientData, interp, argc, argv)
    ClientData    clientData;   /* (char *) to the cmip handle */
    Tcl_Interp	 *interp;
    int		  argc;
    char	**argv;
{
    char         *cmipHdl = (char *) clientData;

    char         *callback    = NULLCP;
    char         *errorback   = NULLCP;

    cmipHandle    *cmiph;
    requestHandle *rh;

    Tcl_HashEntry *ht_entry;
    int            flag = 0;

    int		status;

    char	buf[256];

    if (argc < 2) {
        goto usage;
    }

    /* the optional parameter */
    if (argc >= 4 && argv[2][0] == 'c' && strcmp(argv[2], "callback") == 0) {
        callback = argv[3];
        if (argc == 6 && argv[4][0] == 'e' &&
            strcmp(argv[4], "errorback") == 0) {
            errorback = argv[5];
        } else if (argc >= 5) {
            Tcl_AppendResult(interp, "no such keyword: \"", argv[4], "\"",
                             (char *)NULL);
            return TCL_ERROR;
        }
    } else if (argc >=4) {
        Tcl_AppendResult(interp, "no such keyword: \"", argv[2], "\"",
                         (char *)NULL);
        return TCL_ERROR;
    }

    ht_entry = Tcl_FindHashEntry(&cmip_table, cmipHdl);
    if (ht_entry == NULL) {
        Tcl_AppendResult(interp, "no such cmip handle \"", cmipHdl, "\"",
                         (char *) NULL);
        return TCL_ERROR;
    }
    cmiph = (cmipHandle *) Tcl_GetHashValue(ht_entry);

/* erst gucken, ob requesthandle schon da und loeschen */
    ht_entry = Tcl_FindHashEntry(cmiph->req_table, "eventreport");
    if (ht_entry != NULL) {
	rh = (requestHandle *) Tcl_GetHashValue(ht_entry);
	rh_free(rh);
	Tcl_DeleteHashEntry(ht_entry);
    }

    /* compose the request handle */
/*    sprintf(buf, "eventRep%d", cmiph->req_nr); */
    sprintf(buf, "eventreport");
    rh = (requestHandle *) xmalloc(sizeof(requestHandle));
    rh->reqHdl       = xstrdup(buf);
    rh->request_id   = 0;
    rh->reqId        = xstrdup("EVENTREPORT");
    rh->reqcallback  = callback ? xstrdup(callback) : NULLCP;
    rh->reqerrorback = errorback ? xstrdup(errorback) : NULLCP;
    Tcl_DStringInit(&rh->dStrResult);

    ht_entry = Tcl_CreateHashEntry(cmiph->req_table, rh->reqHdl, &flag);
    if (flag != 1) {
        /* shouldn't really happen */
	Tcl_AppendResult(interp, "*** request handle already exist!? ***",
			 (char *)NULL);
        return TCL_ERROR;
    }
    Tcl_SetHashValue(ht_entry, (ClientData) rh);

    if (callback) { /* asynchron */
	status = TCL_OK;
    } else {
	/* an dieser stelle vielleicht einige zeit warten */
	/* synchron: do while there are outstanding responses */
	do {
	    status = wait(cmipHdl, interp, rh);
	    switch (status) {
	    case TCL_OK:
		Tcl_DStringResult(interp, &rh->dStrResult);
	    case TCL_ERROR:
	    case TCL_CONTINUE:
		break;
	    default:
		sprintf(buf, "\"$d\"", status);
		Tcl_AppendResult(interp, "cmip_eventReport():", 
				 " unexpected returnvalue from wait() ",
				 buf, (char*)NULL);
		return TCL_ERROR;
	    }
	} while (status == TCL_CONTINUE);

	Tcl_DeleteHashEntry(ht_entry);
	rh_free(rh);
    }
    return status;

 usage:
    Tcl_AppendResult(interp, "wrong # args: should be \"",
		     argv[0], " ", argv[1],
		     " [callback <callback> [errorback <errorback>]]\"",
		     (char *)NULL);
    return TCL_ERROR;
} /* cmip_eventReport */
