.TH cmiptcl 1 "18 Aug 1994" "tkined" "tkined Reference Manual"

.SH NAME
cmiptcl \- a Tcl interface to the cmip protocol


.SH CMIP INTERFACE
The Tcl CMIP interface to the CMIP protocol enables Tcl interpreters
to connect to a remote OSI management agents and to use CMIS services.
.TP
.B cmip connect \fIagent\fR \fIhost\fR
Connect to the remote \fIagent\fR of a management information base (MIB)
running
on \fIhost\fR. This command returns a cmip handle, that is the new created
command for this association. The cmip handle starts with "cmip" and ends
with a number, e.g. cmip42.

.TP
.B cmip associations
Returns a list of all cmip handles that have been created using the cmip
connect command.

.TP
.B cmip# get \fIclass\fR \fIinstance\fR [attributes \fIattributeList\fR][\fIoptions\fR]
Retrieve management information on this association (cmip#). The \fIclass\fR
and the \fIinstance\fR define the base managed object that will be returned,
if not modified by the options.
The \fIattributeList\fR may contains the attributes to ask for. {} for no
attributes. Default is all attributes.

.TP
.B cmip# set \fIclass\fR \fIinstance\fR \fIattributeList\fR [\fIoptions\fR]
Set management information at the agent (cmip#). The \fIclass\fR
and the \fIinstance\fR define the base managed object on which
\fIattributeList\fR will be set,
if not modified by the options.

.TP
.B cmip# action \fIclass\fR \fIinstance\fR \fIaction\fR [\fIoptions\fR]
Perform an \fIaction\fR on management information at the agent (cmip#).
The \fIclass\fR and the \fIinstance\fR define the base managed object on
which the \fIaction\fR will be performed,
if not modified by the options.

.TP
.B cmip# delete \fIclass\fR \fIinstance\fR [\fIoptions\fR]
Delete managed object(s) at the agent (cmip#). The \fIclass\fR
and the \fIinstance\fR define the base managed object which
will be deleted,
if not modified by the options.

.RS 5
The available 
.I options
for get, set, action and delete are:
.RE

.RS 
.TP 10
.B scope \fIscope\fR [atomic]
Set the \fIscope\fR for the request. If atomic is given, it tells the agent
to perform the request only, if it can be performed on all scoped managed
objects.
.TP
.BI "filter " filter
Set a \fIfilter\fR on the scoped managed object(s).
.TP
.B callback \fIcallback\fR [errorback \fIerrorback\fR]
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is allright. For possible errors \fIerrorback\fR will be
executed, if given.
.RE

.TP
.B cmip# create \fIclass\fR [\fIoptions\fR]
Create a managed object (MO) at the agent (cmip#).

.RS 5
The available 
.I options
for create are:
.RE

.RS 
.TP 10
.B instance \fIinstance\fR
The \fIinstance\fR specifies the object instance name ???
.TP
.B superior \fIsuperiorInst\fR
The \fIsuperiorInst\fR specifies the object that is the parent in the
containment tree ???
.TP
.B reference \fIreferenceInst\fR
The \fIreferenceInst\fR specifies a reference object instance to be used for
initial attribute values to be copied.
.TP
.B attributes \fIattributeList\fR
The \fIattributeList\fR specifies initial attribute values.
.TP
.B callback \fIcallback\fR [errorback \fIerrorback\fR]
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is allright. For possible errors \fIerrorback\fR will be
executed, if given.
.RE

.TP
.B cmip# cancelGet \fIrequestHandle\fR [\fIcallbacks\fR]
Cancel the outstanding asynchronous GET request at the agent (cmip#),
given by \fIrequestHandle\fR.

.TP
.B cmip# eventReport [\fIcallbacks\fR]
Initialize a callback for event reports.

.RS 5
The
.I callbacks
are:
.RE

.RS 
.TP 10
.B callback \fIcallback\fR [errorback \fIerrorback\fR]
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is allright. For possible errors \fIerrorback\fR will be
executed, if given.
.RE

.TP
.B cmip# requests
Returns a list of all request handles, so the outstanding asynchronous
requests.

.TP
.B cmip# release
Release the association and delete the cmip# command and all structures
related to it.

.SH AUTHORS
The Tcl interface to the OSIMIS cmip library was written by
M. Kernchen <kernchen@ibr.cs.tu-bs.de>.
