/*
 * cmip.h
 *
 * Copyright (c) 1994
 *
 * M. Kernchen
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include <stdlib.h>
#include <string.h>

#if     defined(__GNUG__)
#include <std.h>
extern "C" { int  strncasecmp (const char*, const char*, int); }

#elif   defined(__cplusplus) && defined(AIXV3)
extern "C" { int  strncasecmp (const char*, const char*, int);
             int  strcasecmp (const char*, const char*); }
#endif

/* (schoenfr) extern "C" wrapper added: */
#if defined(__cplusplus) || defined(__GNUG__)
extern "C" {
#include <isode/tailor.h>
}

#else
#include <isode/tailor.h>
#endif

#include "msap.h"
/* zu den naechsten beiden zeilen nochmal erik fragen!!! */
#undef T_NULL
#define T_NULL          (TYPE_DATA + 12)

#include <tcl.h>

/* Namensgebung nochmal ueberdenken */
typedef struct cmipHandle {
    char		*cmipHdl;	/* the cmip handle */
    int			 msd;		/* the association descriptor */
    char		*agent;		/* name of the agent */
    char		*host;		/* name of the host */
    Tcl_HashTable	*req_table;	/* A Tcl-Hashtable for requests */
    unsigned		 req_nr;	/* id number for the next request */
} cmipHandle;

typedef struct requestHandle {
    char		*reqHdl;	/* the request handle */
    int			 msd;
    unsigned		 request_id;	/* the request id */
    char		*reqId;
    char		*reqcallback;
    char		*reqerrorback;
    Tcl_DString		 dStrResult;	/* result that's being built */
} requestHandle;

typedef struct CmipSession {
    Tcl_Interp		*interp;
    char		*handle;
} CmipSession;

extern Tcl_HashTable	cmip_table;	/* Tcl-Hashtable for cmip sessions */


/*
 * The ined cmd and its utility functions to flush the ined queue.
 */

extern int  
ined_cmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
                              int argc, char **argv));

extern char*
xmalloc		_ANSI_ARGS_((unsigned size));

extern char*
xstrdup		_ANSI_ARGS_((char *s));

extern char*
xrealloc	_ANSI_ARGS_((char *ptr, unsigned size));

/* function to free a requestHandle */
extern void
rh_free		_ANSI_ARGS_((requestHandle *rh));
