/*
 * cancelGet.c 
 *
 * Copyright (c) 1994
 *
 * M. Kernchen
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include "cmip.h"

int
cmip_cancelGet(clientData, interp, argc, argv)
    ClientData	  clientData;	/* (char *) to the cmip handle */
    Tcl_Interp	 *interp;
    int		  argc;
    char	**argv;
{
    char	 *cmipHdl = (char *) clientData;

    char	 *reqHdl	= NULLCP;

    char	 *callback	= NULLCP;
    char	 *errorback	= NULLCP;

    MSAPIndication	mi;

    int		  status;

    cmipHandle    *cmiph;
    requestHandle *rh;

    Tcl_HashEntry *ht_entry;
    int		   flag = 0;

    char	buf[256];

    /* parse command line arguments */

    if (argc < 3) {
	goto usage;
    }

    reqHdl = argv[2];

    /* the optional parameter */
    if (argc >= 5 && argv[3][0] == 'c' && strcmp(argv[3], "callback") == 0) {
	callback = argv[4];
	if (argc == 7 && argv[5][0] == 'e' && 
	    strcmp(argv[5], "errorback") == 0) {
	    errorback = argv[6];
	} else if (argc >= 6) {
	    Tcl_AppendResult(interp, "no such keyword: \"", argv[5], "\"",
			     (char *)NULL);
	    return TCL_ERROR;
	}
    } else if (argc >=5) {
	Tcl_AppendResult(interp, "no such keyword: \"", argv[3], "\"",
			 (char *)NULL);
	return TCL_ERROR;
    }

    ht_entry = Tcl_FindHashEntry(&cmip_table, cmipHdl);
    if (ht_entry == NULL) {
        Tcl_AppendResult(interp, "no such cmip handle \"", cmipHdl, "\"",
                         (char *) NULL);
        return TCL_ERROR;
    }
    cmiph = (cmipHandle *) Tcl_GetHashValue(ht_entry);

    ht_entry = Tcl_FindHashEntry(cmiph->req_table, reqHdl);
    if (ht_entry == NULL) {
        Tcl_AppendResult(interp, "no such request handle \"", reqHdl, "\"",
                         (char *) NULL);
        return TCL_ERROR;
    }
    rh = (requestHandle *) Tcl_GetHashValue(ht_entry);
    if (strcmp(rh->reqId, "GET") != 0) {
	Tcl_AppendResult(interp, "no get request", (char*) NULL);
	return TCL_ERROR;
    }

    /* perform the M-GET request */
    status = M_CancelGet(cmiph->msd, cmiph->req_nr, rh->request_id, &mi);
    if (status == NOTOK) {
        Tcl_AppendResult(interp, argv[0], " ", argv[1], ": ",
			  mi.mi_preject.mpr_data,
                         (char *)NULL);
        return TCL_ERROR;
    }
    /* compose the request handle */
    sprintf(buf, "cancelget%d", cmiph->req_nr);
    rh = (requestHandle *) xmalloc(sizeof(requestHandle));
    rh->reqHdl	     = xstrdup(buf);
    rh->request_id   = cmiph->req_nr;
    rh->reqId	     = xstrdup("CANCELGET");
    rh->reqcallback  = callback ? xstrdup(callback) : NULLCP;
    rh->reqerrorback = errorback ? xstrdup(errorback) : NULLCP;
    Tcl_DStringInit(&rh->dStrResult);

    (cmiph->req_nr)++;

    ht_entry = Tcl_CreateHashEntry(cmiph->req_table, rh->reqHdl, &flag);
    if (flag != 1) {
        /* shouldn't really happen */
	Tcl_AppendResult(interp, "*** request handle already exist!? ***",
			 (char *)NULL);
        return TCL_ERROR;
    }
    Tcl_SetHashValue(ht_entry, (ClientData) rh);

    if (callback) { /* asynchron */
	status = TCL_OK;
    } else {
	/* an dieser stelle vielleicht einige zeit warten */
	/* synchron: do while there are outstanding responses */
	do {
	    status = wait(cmipHdl, interp, rh);
	    switch (status) {
	    case TCL_OK:
		Tcl_DStringResult(interp, &rh->dStrResult);
	    case TCL_ERROR:
	    case TCL_CONTINUE:
		break;
	    default:
		sprintf(buf, "\"$d\"", status);
		Tcl_AppendResult(interp, "cmip_cancelGet():", 
				 " unexpected returnvalue from wait() ",
				 buf, (char*)NULL);
		return TCL_ERROR;
	    }
	} while (status == TCL_CONTINUE);

	Tcl_DeleteHashEntry(ht_entry);
	rh_free(rh);
    }
    return status;

 usage:
    Tcl_AppendResult(interp, "wrong # args: should be \"",
		     argv[0], " ", argv[1], " getrequestHandle",
		     " [callback <callback> [errorback <errorback>]]\"",
		     (char *)NULL);
    return TCL_ERROR;
} /* cmip_cancelGet() */
