/*
 * init.c
 *
 * This is the initialization of the scotty tcl extension with commands
 * to get information about TCP/IP networks.
 *
 * Copyright (c) 1994
 *
 * J. Schoenwaelder
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <string.h>

#include <tcl.h>

#include "scotty.h"
#include "xmalloc.h"

/*
 * The default directory name where we will find the scotty library
 * files. This is normally overwritten in the Makefile.
 */

#ifndef SCOTTYLIB
#define SCOTTYLIB "/usr/local/lib/scotty"
#endif

/*
 * Initialize a new scotty extended interpreter.
 */

int
Scotty_Init (interp)
    Tcl_Interp *interp;
{
    char *file;

    /* Write the version number to scotty_version. */
    
    Tcl_SetVar(interp, "scotty_version", SCOTTY_VERSION, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "scotty_lib", SCOTTYLIB, TCL_GLOBAL_ONLY);

#ifndef HAVE_TCLX
    Tcl_CreateCommand (interp, "getclock", getclockCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "sleep", sleepCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "select", Tcl_SelectCmd,
		       (ClientData) NULL, (void (*)()) NULL);
#endif

    Tcl_CreateCommand (interp, "getdate", getdateCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "nslook", nslookCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "job", jobCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "syslog", syslogCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "icmp", icmpCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "dns", dnsCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "ntp", ntpCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "udp", udpCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "tcp", tcpCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "sunrpc", sunrpcCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "rpc", rpcCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
    Tcl_CreateCommand (interp, "http", httpCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

    Tcl_CreateCommand (interp, "ined", inedCmd,
		       (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

    if (SNMP_Init (interp) != TCL_OK) {
        return TCL_ERROR;
    }

#ifdef HAVE_BONES
    Bones_Init (interp);
#endif

#ifdef HAVE_OSIMIS
    if (CMIP_Init (interp) != TCL_OK) {
        return TCL_ERROR;
    }
#endif

    /*
     * Evaluate the commands stored in scotty's init.tcl file.
     */

    file = xmalloc (strlen(SCOTTYLIB) + 10);
    strcpy (file, SCOTTYLIB);
    strcat (file, "/init.tcl");
    if (access (file, R_OK) == 0) {
        if (Tcl_EvalFile (interp, file) != TCL_OK) 
	    return TCL_ERROR;
    } else if (access ("init.tcl", R_OK) == 0) {
	if (Tcl_EvalFile (interp, "init.tcl") != TCL_OK) 
	    return TCL_ERROR;
    } else if (access ("../init.tcl", R_OK) == 0) {
	if (Tcl_EvalFile (interp, "../init.tcl") != TCL_OK) 
	    return TCL_ERROR;
    } else {
        Tcl_AppendResult (interp, "no initialization file: tried ",
			  SCOTTYLIB, "/init.tcl, init.tcl, and ../init.tcl",
			  (char *) NULL);
        return TCL_ERROR;
    }
    free (file);

    return TCL_OK;
}

