# This script generates a counter with start and stop buttons.

proc timer::mk {w args} {
frame $w
label $w.counter -text 0.00 -relief raised -width 10
button $w.start -text Start -command "set stop 0; timer::tick $w"
button $w.stop -text Stop -command {set stop 1}
pack append $w $w.counter {bot fill} $w.start {left expand fill} \
	$w.stop {right expand fill}
}

set seconds 0
set hundredths 0
set stop 0

set interval 10

proc timer::action {w} { puts stdout $w }

proc timer::tick {w} {
    global seconds hundredths stop interval
    if $stop return
    after 20 timer::tick $w
    set hundredths [expr $hundredths+2]
    if {$seconds > $interval} "timer::action $w; set stop 1"
    if {$hundredths >= 100} {
	set hundredths 0
	set seconds [expr $seconds+1]
    }
    $w.counter config -text [format "%d.%2d" $seconds $hundredths]
}

proc timer::test {} {
bind . <Control-c> {destroy .}
bind . <Control-q> {destroy .}
focus .
}
