
proc tablet::mk w {
    frame $w -background lightblue
    set c $w.frame.canvas
    frame $w.frame -relief raised -bd 2
    button $w.ok -text "OK" -command "destroy $w"
    pack append $w $w.ok {bottom frame se} \
	    $w.frame {top expand fill}

    canvas $c -scrollregion { 0c 0c 30c 20c} \
      -height 100m -width 150m -background white
    
    scrollbar $w.frame.vscroll  -relief sunken -command "$c yview"
    scrollbar $w.frame.hscroll -orient horiz -relief sunken -command "$c xview"
    pack append $w.frame $w.frame.hscroll {bottom fillx} \
	    $w.frame.vscroll {right filly} $c {expand fill}
    $c config -xscroll "$w.frame.hscroll set" -yscroll "$w.frame.vscroll set"


    $c bind item <Any-Enter> "item-enter $c"
    $c bind item <Any-Leave> "item-leave $c"
    bind $c <2> "$c scan mark %x %y"
    bind $c <B2-Motion> "$c scan dragto %x %y"
    bind $c <3> "item-mark $c %x %y"
    bind $c <B3-Motion> "item-stroke $c %x %y"
    bind $c <Control-f> "items-underarea $c"
    bind $c <1> "item-startdrag $c %x %y"
    bind $c <B1-Motion> "item-drag $c %x %y"
    bind $w <Any-Enter> "focus $c"

    return $c
}


proc tablet::test {} {
set w [tablet::mk .c]
$w create oval 5c 5c 10c 10c -fill red -outline blue
pack append . .c {top}
}


proc item-enter {c} {
    global restoreCmd

    if {[tk colormodel $c] != "color"} {
	set restoreCmd {}
	return
    }
    set type [$c type current]
    if {$type == "window"} {
	set restoreCmd {}
	return
    }
    if {$type == "bitmap"} {
	set bg [lindex [$c itemconf current -background] 4]
	set restoreCmd [list $c itemconfig current -background $bg]
	$c itemconfig current -background SteelBlue2
	return
    }
    set fill [lindex [$c itemconfig current -fill] 4]
    if {(($type == "rectangle") || ($type == "oval") || ($type == "arc"))
	    && ($fill == "")} {
	set outline [lindex [$c itemconfig current -outline] 4]
	set restoreCmd "$c itemconfig current -outline $outline"
	$c itemconfig current -outline SteelBlue2
    } else {
	set restoreCmd "$c itemconfig current -fill $fill"
	$c itemconfig current -fill SteelBlue2
    }
}

proc item-leave {c} {
    global restoreCmd

    eval $restoreCmd
}

# Utility procedures for stroking out a rectangle and printing what's
# underneath the rectangle's area.

proc item-mark {c x y} {
    global areaX1 areaY1
    set areaX1 [$c canvasx $x]
    set areaY1 [$c canvasy $y]
    $c delete area
}

proc item-stroke {c x y} {
    global areaX1 areaY1 areaX2 areaY2
    set x [$c canvasx $x]
    set y [$c canvasy $y]
    if {($areaX1 != $x) && ($areaY1 != $y)} {
	$c delete area
	$c addtag area withtag [$c create rect $areaX1 $areaY1 $x $y \
		-outline black]
	set areaX2 $x
	set areaY2 $y
    }
}

proc items-underarea {c} {
    global areaX1 areaY1 areaX2 areaY2
    set area [$c find withtag area]
    set items ""
    foreach i [$c find enclosed $areaX1 $areaY1 $areaX2 $areaY2] {
	if {[lsearch [$c gettags $i] item] != -1} {
	    lappend items $i
	}
    }
    puts stdout "Items enclosed by area: $items"
    set items ""
    foreach i [$c find overlapping $areaX1 $areaY1 $areaX2 $areaY2] {
	if {[lsearch [$c gettags $i] item] != -1} {
	    lappend items $i
	}
    }
    puts stdout "Items overlapping area: $items"
}

set areaX1 0
set areaY1 0
set areaX2 0
set areaY2 0

# Utility procedures to support dragging of items.

proc item-startdrag {c x y} {
    global lastX lastY
    set lastX [$c canvasx $x]
    set lastY [$c canvasy $y]
}

proc item-drag {c x y} {
    global lastX lastY
    set x [$c canvasx $x]
    set y [$c canvasy $y]
    $c move current [expr $x-$lastX] [expr $y-$lastY]
    set lastX $x
    set lastY $y
}

# Procedure that's invoked when the button embedded in the canvas
# is invoked.

proc butPress {w color} {
    set i [$w create text 25c 18.1c -text "Ouch!!" -fill $color -anchor n]
    after 500 "$w delete $i"
}
