#include "hush.h"

class canvas_handler : public handler {
public:

canvas_handler( canvas* cv ) { c = cv; moving = 0; }

void press( event& e) {
	x = e.x(); y = e.y();
	id = c->overlapping(x, y);
	if (id) moving = 1;
	}

void motion( event& e ) {
	if (moving) {
		id.move( e.x() - x, e.y() - y );
		x = e.x(); y = e.y();
		}
	}

void release( event& ) { moving = 0; }

protected:
canvas* c;
int x,y;
int moving;
item id;
};


void program( kit* tk, int, char** ) {
 
    tk->trace();

    canvas* c = new canvas(".canvas");
    c->handler(new canvas_handler(c));

    c->oval(120,60,180,180,"-fill blue");
    c->bitmap(100,100,"@test2.gif");
    c->bitmap(140,140,"@bishop.bm");

    tk->pack(c);
    tk->pack(".quit");
}

int main (int  argc, char  **argv) {
    session* s = new session(argc,argv,"root");
    return s->run(program);
}
