#include <hush/hush.h>

// hush startup

void hush_handlers(kit* tk) {

#ifndef HCLONLY
handler* h = new filechooser;
tk->action("filechooser",h);
#endif

}

void init_hcl(kit* tk) {
Tcl_Interp* interp = tk->interp();
#ifdef HCLEXPECT
    //init_expect( interp );
#endif
}


void init_hush(kit* tk) {
Tcl_Interp* interp = tk->interp();

init_hcl( tk );

#ifndef HCLONLY
init_tk( tk);
#endif

#ifdef HUSHWIDGETS
    init_graph( tk );
    init_photo( tk );
#endif /* HUSHWIDGETS */

    hush_handlers(tk);
}

// from tk -- tkAppInit.c

/*
 * The following variable is a special hack that allows applications
 * to be linked using the procedure "main" from the Tk library.  The
 * variable generates a reference to "main", which causes main to
 * be brought in from the library (and all of Tk and Tcl with it).
 */

//extern int main(int,char**);
//int *tclDummyMainPtr = (int *) main;

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

#ifndef EXTENDED

int
Tcl_AppInit(
    Tcl_Interp *interp )		/* Interpreter for application. */
{
#ifndef HCLONLY
    Tk_Window main;

    main = Tk_MainWindow(interp);
#endif

    /*
     * Call the init procedures for included packages.  Each call should
     * look like this:
     *
     * if (Mod_Init(interp) == TCL_ERROR) {
     *     return TCL_ERROR;
     * }
     *
     * where "Mod" is the name of the module.
     */


    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

#ifndef HCLONLY

    if (Tk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

#endif


    /*
     * Call Tcl_CreateCommand for application-specific commands, if
     * they weren't already created by the init procedures called above.
     */

    /*
     * Specify a user-specific startup file to invoke if the application
     * is run interactively.  Typically the startup file is "~/.apprc"
     * where "app" is the name of the application.  If this line is deleted
     * then no user-specific startup file will be run under any conditions.
     */

    tcl_RcFileName = "~/.hushrc";
    return TCL_OK;
}

#endif


#ifdef EXTENDED
/*
 * tkXstartup.c --
 *
 * Startup code for the wishx and other Tk & Extended Tcl based applications.
 *-----------------------------------------------------------------------------
 * Copyright 1991-1993 Karl Lehenbauer and Mark Diekhans.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  Karl Lehenbauer and
 * Mark Diekhans make no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *-----------------------------------------------------------------------------
 * $Id: tkXstartup.c,v 1.5 1993/08/31 23:03:20 markd Exp $
 *-----------------------------------------------------------------------------
 */

 extern "C" {
// #include <tcl-tk/tclExtdInt.h>
 void Tcl_SetLibraryDirEnvVar( Tcl_Interp*, char*, char*, char*, char*);
 }



/*
 *-----------------------------------------------------------------------------
 *
 * TkX_Startup --
 *
 *   Do basic startup for wishx.  This is called before Tk_CreateMainWindow.
 * It does the basic TclX shell environment intialization and then doctors
 * the TK_LIBRARY environment variable to point to our library.  This does
 * not source the Tk init file, that must be done after the main window is
 * created.
 *
 * Parameters:
 *   o interp - A pointer to the interpreter.
 *   o interactive (I) - TRUE if this is interactive, FALSE otherwise.
 *   o errorSignalProc (I) - Function to call when an error signal occurs.
 *     This can handle flushing of interactive input buffers if necessary.
 *     Ignored if interactive is FALSE.
 *-----------------------------------------------------------------------------
 */
void
TkX_Startup ( //interp, interactive, errorSignalProc)
    Tcl_Interp          *interp,
    int                  interactive,
    TkX_ShellSignalProc *errorSignalProc)
{

    tclAppName     = "hush";
    tclAppLongname = "Hyper Utility Shell - hush";
    tclAppVersion  = TK_VERSION;
    
    Tcl_ShellEnvInit (interp, 
                      TCLSH_ABORT_STARTUP_ERR |
                          (interactive ? TCLSH_INTERACTIVE : 0));

   
    

    /*
    if ( interactive ) Tcl_SetupSigInt ();
    */

    tclSignalBackgroundError = Tk_BackgroundError;
    if (interactive)
        tclErrorSignalProc = errorSignalProc;

    
    Tcl_SetLibraryDirEnvVar (interp,
                             "TK_LIBRARY",
                             TK_MASTERDIR,
                             "tk",
                             "");

}


/*
 *-----------------------------------------------------------------------------
 *
 * TkX_WishInit --
 *
 *   Do the rest of the wish initalization.  This sources the tk.tcl file and
 * sets up auto_path.
 *
 * Parameters:
 *   o interp - A pointer to the interpreter.
 *-----------------------------------------------------------------------------
 */

void
TkX_WishInit (interp)
    Tcl_Interp *interp;
{
    if (Tcl_ProcessInitFile (interp,
                             "TK_LIBRARY",
                             TK_MASTERDIR,
                             "tk",
                             "",
                             "tk.tcl")  == TCL_ERROR)
        goto errorExit;

    return;

  errorExit:
        Tcl_ErrorAbort (interp, 0, 255);
}

#endif /* EXTENDED */
