#ifndef HANDLER_H
#define HANDLER_H

class event;
class kit;

extern event* dummy_event; /// defaults to press

extern handler_callback(client* data ,kit* tk, int argc, char** argv);

class handler : public client {
public:
virtual int dispatch(kit* _tk, int _argc, char** _argv);

virtual int operator()();

virtual void press( event&  ) { }
virtual void release( event&  ) { }
virtual void keypress( event&  ) { }
virtual void keyrelease( event&  ) { }
virtual void motion( event&  ) { }
virtual void enter( event&  ) { }
virtual void leave( event&  ) { }
virtual void other( event& ) { cout << "** other event**"; }

protected:
int argc;
char** argv;
kit* tk;
};

// the default dispatch looks as 

/*
int handler::dispatch(kit* _tk, int _argc, char** _argv) {
	 
	 tk = _tk; argc = _argc; argv = _argv;

	 event e = tk->event();
	 if ( e.type() == ButtonPress ) press(e);
	 else if ( e.type() == ButtonRelease ) release(e);
	 else if ( e.type() == KeyPress ) keypress(e);
	 else if ( e.type() == KeyRelease ) keyrelease(e);
	 else if ( e.type() == MotionNotify ) motion(e);
	 else if ( e.type() == EnterNotify ) enter(e);
	 else if ( e.type() == LeaveNotify ) leave(e);
	 else other(e);
	 return OK;
	 }
*/

// and the function that invokes the handler looks as

inline
int handler_callback(client* data , kit* tk, int argc, char** argv) {
	 //handler* h = (handler*) data;
	 return ((handler*)data)->dispatch(tk,argc,argv);
}

#endif
