/*
 * xpixmap.c -- v1.1
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <x11/xlib.h>
#include <x11/xutil.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

extern HDC GetDrawableDC( Drawable );
extern void ReleaseDrawableDC(HWND , HDC);


#define BMP_PLANES 1
#define BMP_PIXELS 1

static BYTE 
rebirth(BYTE byte)
{
    int i;
    BYTE work = (BYTE) ~byte, result = 0, bit = 0x80;

    for (i = 0; i < 8; i++) {
   	if (work & 0x01) {
   	    result |= bit;
   	}
   	work >>= 1;
   	bit >>= 1;
   }
   return result;
}     	

Pixmap FAR PASCAL
XCreateBitmapFromData(Display *dummy1, Drawable dummy2, const char *data,
	unsigned int width, unsigned int height)
{
    int byteWidth, dataWidth;
    int i, j, adjust = 0;
    BYTE *bPtr;
    HBITMAP hbmp;

    byteWidth = dataWidth = (width + 7) / 8;

    if (dataWidth % 2) {
	byteWidth += 1;
    	adjust = 1;
    }

    bPtr = (BYTE *) malloc(byteWidth * height);
    for (i = 0; (unsigned)i <	height; i++) {
        for (j = 0; j < byteWidth; j++) {
	    if (j == (byteWidth - 1) && adjust) {
	    	bPtr[i * byteWidth + j] = '\0';
	    } else {
		bPtr[i * byteWidth + j] = rebirth((BYTE)data[i * dataWidth + j]); 
	    }
    	}
    }
    hbmp = CreateBitmap(width, height, BMP_PLANES, BMP_PIXELS, bPtr);
    free(bPtr);

    return hbmp ;
}
void  FAR PASCAL
XCopyArea(Display *dummy1, Drawable src, Drawable dest, GC dummy, 
	int src_x, int src_y, unsigned int width, unsigned int height, 
	int dest_x, int dest_y)
{
    HDC hsrc, hdest;
    int dx, dy, sx, sy, cx, cy, ow = width;

    hdest = GetDrawableDC(dest);
    hsrc = GetDrawableDC(src);

    for (dy = dest_y, sy = src_y; height; dy += cy, sy += cy) {
	width = ow;
	cy = (height > 256)? 256: height;
	height -= cy;
	for (dx = dest_x, sx = src_x; width; dx += cx, sx += cx) {
	    cx = (width > 256)? 256: width;
	    width -= cx;
	    BitBlt( hdest, dx, dy, cx, cy, hsrc,  sx,  sy, SRCCOPY );
	}
    }

    ReleaseDrawableDC(src, hsrc);
    ReleaseDrawableDC(dest, hdest);
}

void FAR PASCAL
XCopyPlane(Display *dummy1, Drawable src, Drawable dest, GC gc,
	int src_x, int src_y, unsigned int width, unsigned int height, 
	int dest_x, int dest_y, unsigned long dummy)
{
    HDC hsrc, hdest;
    HBRUSH hPrevBrush;

    hdest = GetDrawableDC(dest);
    hsrc = GetDrawableDC(src);
    hPrevBrush = SelectObject(hdest, CreateSolidBrush(gc->foreground));

    BitBlt( hdest, dest_x, dest_y, width, height,
		hsrc,  src_x,  src_y,  0xB8074A);
    DeleteObject(SelectObject(hdest, hPrevBrush));
    ReleaseDrawableDC(src, hsrc);
    ReleaseDrawableDC(dest, hdest);
}

Pixmap FAR PASCAL
XCreatePixmap(Display *dummy1, Drawable dummy2, 
	unsigned int width, unsigned int height, unsigned int dummy3)
{
	BITMAPINFOHEADER bmih;
	HBITMAP hBitmap;
	HDC hdc;

	bmih.biSize = sizeof(BITMAPINFOHEADER);
	bmih.biWidth = (DWORD) width;
	bmih.biHeight = (DWORD) height;
	bmih.biPlanes = 1;
	bmih.biBitCount = 8;
	bmih.biCompression = 0;
	bmih.biSizeImage = 0;
	bmih.biXPelsPerMeter = 0;
	bmih.biYPelsPerMeter = 0;
	bmih.biClrUsed = 0;
	bmih.biClrImportant = 0;
	hdc = GetDC(NULL);
	hBitmap = CreateDIBitmap(hdc, &bmih, 0L, NULL, NULL, 0);
	ReleaseDC(NULL, hdc);
	return hBitmap;
}

void FAR PASCAL
XFreePixmap(Display *dummy, Pixmap pixmap)
{
	if (pixmap != NULL)
		DeleteObject(pixmap);
}

int FAR PASCAL 
XReadBitmapFile(Display *dummy1, Drawable dummy2, const char *filename,
	unsigned int *width, unsigned int *height, Pixmap *bitmap,
	int *x_hot, int *y_hot)
{
    struct _stat st;
    char *buffer;
    FILE *fp;
    char *bits;
    HBITMAP hbm;
    BITMAPFILEHEADER *bmfh;
    BITMAPINFOHEADER *bmih;
    BITMAPINFO *bmi;
    HDC hdc;
    int result;

    if (_stat(filename, &st) != 0)				   
 	return BitmapOpenFailed;				   
    if ((fp = fopen(filename, "rb")) == NULL)	   
 	return BitmapOpenFailed;
    if ((buffer = (char *)malloc((size_t)st.st_size)) == NULL) {
 	result = BitmapNoMemory;
	goto close_end;
    }
    if (fread(buffer, (size_t)st.st_size, 1, fp) != 1) {	
 	result = BitmapFileInvalid;
	goto  free_end;
    }
    bmfh = (BITMAPFILEHEADER *)buffer;
    bmih = (BITMAPINFOHEADER *)(buffer + sizeof(BITMAPFILEHEADER));
    bmi = (BITMAPINFO *)bmih;
    bits = buffer + bmfh->bfOffBits;		

    if (strncmp((char *)&bmfh->bfType, "BM", 2) != 0) {	 
 	result = BitmapFileInvalid;
	goto free_end;
    }
    hdc = GetDC(NULL);
    hbm = CreateDIBitmap(hdc, bmih,	CBM_INIT, bits, bmi, DIB_RGB_COLORS);	 
    ReleaseDC(NULL, hdc);
    if (hbm == NULL) {
 	result =  BitmapFileInvalid;
	goto free_end;
    }
    *bitmap = hbm;
    *width = (unsigned int)bmih->biWidth;
    *height = (unsigned int)bmih->biHeight;
    *x_hot = 0;
    *y_hot = 0;		
    result = BitmapSuccess;

free_end:
    free(buffer);	 
close_end:
    fclose(fp);
    return result;
}	
