/*
 * xgraphic.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <X11/Xlib.h>
#include <stdlib.h> 
#include <string.h>
#ifdef KANJI
#include <mbstring.h>
#endif /* KANJI */
#include <math.h>

#define PI 3.14159265358979

static HBITMAP hbmpCompat1;
static HBITMAP hbmpCompat2;
static POINT new_points[256];



HDC
GetDrawableDC( drawable )
HANDLE drawable;
{
    if(IsWindow(drawable)) {
	return GetDC(drawable); 
    } else {
	HDC hdc, hdcMemory;
	hdc = GetDC((HWND) NULL);
    	hdcMemory = CreateCompatibleDC(hdc);
	ReleaseDC((HWND) NULL, hdc);
	if(hbmpCompat1 == None) 
	    hbmpCompat1 = SelectObject(hdcMemory, drawable);
	else
	    hbmpCompat2 = SelectObject(hdcMemory, drawable);
	     
	return hdcMemory;
    }
}

void 
ReleaseDrawableDC( drawable, hdc )
HANDLE drawable;
HDC hdc;
{
    if(IsWindow(drawable)) {
    	ReleaseDC(drawable, hdc);
    } else {
	if (hbmpCompat1 != None) {
    	    SelectObject(hdc, hbmpCompat1);
	    hbmpCompat1 = None;
	} else {
    	    SelectObject(hdc, hbmpCompat2);
	    hbmpCompat2 = None;
	}
	DeleteDC(hdc);
    }
}

static POINT *
GetOriginalPoints( points, npoints )
XPoint points[];
int npoints;
{
    POINT *new_points;
    register int i;

    if(npoints > 256)
	return NULL;

    new_points[0].x = points[0].x;
    new_points[0].y = points[0].y;
    for (i = 1 ; i < npoints ; i++) {
	new_points[i].x = new_points[i-1].x + points[i].x;
	new_points[i].y = new_points[i-1].y + points[i].y;
    }
    return new_points;
}

static void
GetBoxPoints(points, n, left, top, right, bottom)
XPoint points[];
int n;
int *left, *top, *right, *bottom;
{
    int i;

    *left = *right = points[0].x;
    *top = *bottom = points[0].y;
    for (i = 1; i < n; i++) {
    	if (*left > points[i].x) *left = points[i].x;
    	if (*right < points[i].x) *right = points[i].x;
    	if (*top > points[i].y) *top = points[i].y;
    	if (*bottom < points[i].y) *bottom = points[i].y;
    }
}

static void
ShiftPoints(points, n, x, y)
XPoint *points;
int n;
int x, y;
{
    int i;

    for (i = 0; i < n; i++, points++) {
    	points->x -= x;
    	points->y -= y;
    }
}

/*
 *  XDrawLine
 *
 */

void FAR PASCAL
XDrawLine(display, d, gc, x1, y1, x2, y2)
Display *display;
Drawable d;
GC gc;
int x1, y1, x2, y2;
{
    HDC hdc;
    HPEN hpen, hpenPrev;

    hdc = GetDrawableDC(d);
    SetROP2(hdc, gc->function);

    hpen = CreatePen(gc->line_style, gc->line_width, gc->foreground);

    if ((gc->fill_style == FillStippled || gc->fill_style == FillOpaqueStippled)
		&& gc->stipple != None) {
	HDC hdcMem;
	HBITMAP hbmp, hbmpPrev;
	HBRUSH hbrPat, hbrPrev;
	int width, height;

	width = max(x1, x2) + 30;
	height = max(y1, y2) + 30;

	hdcMem = CreateCompatibleDC(hdc);
	hbmp = CreateCompatibleBitmap(hdc, width, height);
	hbmpPrev = SelectObject(hdcMem, hbmp);
	hpenPrev = SelectObject(hdcMem, hpen);

	hbrPat = CreatePatternBrush(gc->stipple);
	hbrPrev = SelectObject(hdc, hbrPat);

	PatBlt(hdcMem, 0, 0, width, height, BLACKNESS);
	MoveTo(hdcMem, x1, y1);
	LineTo(hdcMem, x2, y2);

	
	BitBlt(hdc, 0, 0, width, height, hdcMem, 0, 0, 0x00AE0B06);

	PatBlt(hdcMem, 0, 0, width, height, WHITENESS);
	MoveTo(hdcMem, x1, y1);
	LineTo(hdcMem, x2, y2);

	BitBlt(hdc, 0, 0, width, height, hdcMem, 0, 0, 0x00A803A9);
	DeleteObject(SelectObject(hdc, hbrPrev));

	DeleteObject(SelectObject(hdcMem, hpenPrev));
	DeleteObject(SelectObject(hdcMem, hbmpPrev));
	DeleteDC(hdcMem);
    } else {
	hpenPrev = SelectObject(hdc, hpen);
	MoveTo(hdc, x1, y1);
	LineTo(hdc, x2, y2);
	DeleteObject(SelectObject(hdc, hpenPrev));
    }
    ReleaseDrawableDC(d, hdc);
}

/*
 *  XDrawLines
 *
 */

void FAR PASCAL
XDrawLines(display, d, gc, points, npoints, mode)
Display *display;
Drawable d;
GC gc;
XPoint points[];
int npoints, mode;
{
    HDC hdc;
    HPEN hpen, hpenPrev;
    POINT *xp;

    hdc = GetDrawableDC(d);
    SetROP2(hdc, gc->function);

    hpen = CreatePen(gc->line_style, gc->line_width, gc->foreground);

    xp = (mode == CoordModePrevious)?GetOriginalPoints(points, npoints):(POINT *)points;
    if (xp == NULL) return;
    if ((gc->fill_style == FillStippled || gc->fill_style == FillOpaqueStippled)
	    && gc->stipple != None) {
	HDC hdcMem;
	HBITMAP hbmp, hbmpPrev;
	HBRUSH hbrPat, hbrPrevPat;
	int x, y, width, height;

	GetBoxPoints(xp, npoints, &x, &y, &width, &height);
	x -= gc->line_width;
	y -= gc->line_width;
	ShiftPoints(xp, npoints, x, y);
	width -= x-1 - gc->line_width * 2;
	height -= y-1 - gc->line_width * 2;

	hdcMem = CreateCompatibleDC(hdc);
	hbmp = CreateCompatibleBitmap(hdc, width, height);
	hbmpPrev = SelectObject(hdcMem, hbmp);
	hpenPrev = SelectObject(hdcMem, hpen);

	hbrPat = CreatePatternBrush(gc->stipple);
	hbrPrevPat = SelectObject(hdc, hbrPat);

	PatBlt(hdcMem, 0, 0, width, height, BLACKNESS);
	Polyline(hdcMem, xp, npoints);

	BitBlt(hdc, x, y, width, height, hdcMem, 0, 0, 0x00AE0B09);

	PatBlt(hdcMem, 0, 0, width, height, WHITENESS);
	Polyline(hdcMem, xp, npoints);
	BitBlt(hdc, x, y, width, height, hdcMem, 0, 0, 0x00A803A9);
	DeleteObject(SelectObject(hdc, hbrPrevPat));

	DeleteObject(SelectObject(hdcMem, hpenPrev));
	DeleteObject(SelectObject(hdcMem, hbmpPrev));
	DeleteDC(hdcMem);
    } else {
	hpenPrev = SelectObject(hdc, hpen);
	Polyline(hdc, xp, npoints);
	DeleteObject(SelectObject(hdc, hpenPrev));
    }
    ReleaseDrawableDC(d, hdc);
}


static void
DrawOrFillArc(display, d, gc, x, y, width, height, angle1, angle2, fill)
Display *display;
Drawable d;
GC gc;
int x, y; /* left top */
unsigned int width, height;
int angle1;	/* angle1: three-o'clock (deg*64) */
int angle2; 	/* angle2: relative (deg*64) */
int fill; /* ==0 draw, !=0 fill */
{
    HDC hdc;
    HPEN hpen, hpenPrev;
    HBRUSH hbr, hbrPrev;
    int xr, yr, xstart, ystart, xend, yend;
    double radian_start, radian_end, radian_tmp;

	hdc = GetDrawableDC(d);

    if(width % 2 == 1)
	xr = width / 2;
    else
	xr = (width - 1) / 2;

    if (height % 2 == 1)
	yr = height / 2;
    else
	yr = (height - 1) / 2;

    radian_start = (double)angle1 / 64 * PI / 180;
    radian_end = (double)(angle1+angle2) / 64 * PI / 180;
    if( angle2 < 0 ) {
	radian_tmp = radian_start;
	radian_start = radian_end;
	radian_end = radian_tmp;
    }

    xstart = x + (int)( (double)xr * (1+cos(radian_start)) );
    ystart = y + (int)( (double)yr * (1-sin(radian_start)) );
    xend = x + (int)( (double)xr * (1+cos(radian_end)) );
    yend = y + (int)( (double)yr * (1-sin(radian_end)) );

    SetROP2(hdc, gc->function);


    if( !fill ) {
	hpen = CreatePen(gc->line_style, gc->line_width, gc->foreground);
	hpenPrev = SelectObject(hdc, hpen);
	Arc(hdc, x, y, x + width, y + height, xstart, ystart, xend, yend);
	DeleteObject(SelectObject(hdc, hpenPrev));
    }
    else {

	hpen = CreatePen(PS_SOLID, 1, gc->foreground);
	hbr = CreateSolidBrush(gc->foreground);

	if ((gc->fill_style == FillStippled || gc->fill_style == FillOpaqueStippled)
		&& gc->stipple != None) {
	    HDC hdcMem;
	    HBITMAP hbmp, hbmpPrev;
	    HBRUSH hbrPat, hbrPrevPat;
	
	    hdcMem = CreateCompatibleDC(hdc);
	    hbmp = CreateCompatibleBitmap(hdc, width, height);
	    hbmpPrev = SelectObject(hdcMem, hbmp);
	    hpenPrev = SelectObject(hdcMem, hpen);
	    hbrPrev = SelectObject(hdcMem, hbr);

	    PatBlt(hdcMem, 0, 0, width, height, BLACKNESS);
	    if ( gc->arc_mode == ArcChord ) {
	    	Chord(hdcMem, 0, 0, width, height, xstart - x, ystart -y, xend-x, yend-y);
	    } else {
	    	Pie(hdcMem, 0, 0, width, height, xstart-x , ystart-y, xend-x, yend-y);
	    }

	    hbrPat = CreatePatternBrush(gc->stipple);
	    hbrPrevPat = SelectObject(hdc, hbrPat);
//	    BitBlt(hdc, x , y, width, height, hdcMem, 0, 0, SRCCOPY);
	    BitBlt(hdc, x , y, width, height, hdcMem, 0, 0, 0x00AE0B06);

	    PatBlt(hdcMem, 0, 0, width, height, WHITENESS);
	    if ( gc->arc_mode == ArcChord ) {
	    	Chord(hdcMem, 0, 0, width, height, xstart - x, ystart -y, xend-x, yend-y);
	    } else {
	    	Pie(hdcMem, 0, 0, width, height, xstart-x , ystart-y, xend-x, yend-y);
	    }
	    BitBlt(hdc, x , y, width, height, hdcMem, 0, 0, 0x00A803A9);


	    DeleteObject(SelectObject(hdc, hbrPrevPat));

	    DeleteObject(SelectObject(hdcMem, hpenPrev));
	    DeleteObject(SelectObject(hdcMem, hbrPrev));
	    DeleteObject(SelectObject(hdcMem, hbmpPrev));
	    DeleteDC(hdcMem);

	} else {
	    hpenPrev = SelectObject(hdc, hpen);
	    hbrPrev = SelectObject(hdc, hbr);
	    if ( gc->arc_mode == ArcChord ) {
	        Chord(hdc, x, y, x + width, y + height, xstart, ystart, xend, yend);
	    } else if ( gc->arc_mode == ArcPieSlice ) {
	       Pie(hdc, x, y, x + width, y + height, xstart, ystart, xend, yend);
	    }
	    DeleteObject(SelectObject(hdc, hpenPrev));
	    DeleteObject(SelectObject(hdc, hbrPrev));
	}
    }
    ReleaseDrawableDC(d, hdc);
}

void FAR PASCAL
XDrawArc(display, d, gc, x, y, width, height, angle1, angle2)
Display *display;
Drawable d;
GC gc;
int x, y;
unsigned int width, height;
int angle1, angle2;
{
    DrawOrFillArc(display, d, gc, x, y, width, height, angle1, angle2, 0);
}

void FAR PASCAL 
XFillArc(display, d, gc, x, y, width, height, angle1, angle2)
Display *display;
Drawable d;
GC gc;
int x, y;
unsigned int width, height;
int angle1, angle2;
{
    DrawOrFillArc(display, d, gc, x, y, width, height, angle1, angle2, 1);
}


void FAR PASCAL
XFillPolygon(display, d, gc, points, n, shape, mode)
Display *display;
Drawable d;
GC gc;
XPoint *points;
int n, shape, mode;
{
    HDC hdc;
    HPEN hpen, hpenPrev;
    HBRUSH hbr, hbrPrev;
    POINT *xp;

    hdc = GetDrawableDC(d);
    SetROP2(hdc, gc->function);
    SetPolyFillMode(hdc, gc->fill_rule);

    hpen = CreatePen(PS_NULL, 0, gc->foreground);
    hbr = CreateSolidBrush(gc->foreground);


    xp = (mode == CoordModePrevious)?GetOriginalPoints(points, n):(POINT *)points;
    if (xp == NULL) return;
    if ((gc->fill_style == FillStippled || gc->fill_style == FillOpaqueStippled)
	    && gc->stipple != None) {
	HDC hdcMem;
	HBITMAP hbmp, hbmpPrev;
	HBRUSH hbrPat, hbrpatPrev;
	int x, y, width, height;

	GetBoxPoints(xp, n, &x, &y, &width, &height);
	ShiftPoints(xp, n, x, y);
	width -= x-1;
	height -= y-1;

	hdcMem = CreateCompatibleDC(hdc);
	hbmp = CreateCompatibleBitmap(hdc, width, height);
	hbmpPrev = SelectObject(hdcMem, hbmp);
	hpenPrev = SelectObject(hdcMem, hpen);
	hbrPrev = SelectObject(hdcMem, hbr);

	hbrPat = CreatePatternBrush(gc->stipple);
	hbrpatPrev = SelectObject(hdc, hbrPat);

	PatBlt(hdcMem, 0, 0, width, height, BLACKNESS);
	Polygon(hdcMem, xp, n);
	BitBlt(hdc, x, y, width, height, hdcMem, 0, 0, 0x00AE0B09);

	PatBlt(hdcMem, 0, 0, width, height, WHITENESS);
	Polygon(hdcMem, xp, n);
	BitBlt(hdc, x, y, width, height, hdcMem, 0, 0, 0x00A803A9);

	DeleteObject(SelectObject(hdc, hbrpatPrev));

	DeleteObject(SelectObject(hdcMem, hpenPrev));
	DeleteObject(SelectObject(hdcMem, hbrPrev));
	DeleteObject(SelectObject(hdcMem, hbmpPrev));
	DeleteDC(hdcMem);
     } else {
	hpenPrev = SelectObject(hdc, hpen);
	hbrPrev = SelectObject(hdc, hbr);
	Polygon(hdc, xp, n);
	DeleteObject(SelectObject(hdc, hpenPrev));
	DeleteObject(SelectObject(hdc, hbrPrev));
    }
    ReleaseDrawableDC(d, hdc);
}

void FAR PASCAL  
XDrawRectangle(display, d, gc, x, y, width, height)
Display *display;
Drawable d;
GC gc;
int x, y;
unsigned int width, height;
{
    HDC hdc;
    HPEN hPen, hPrevPen;
    XPoint points[5];

    points[0].x = points[1].x = points[4].x = x; 
    points[2].x = points[3].x = x + width;
    points[0].y = points[3].y = points[4].y = y;
    points[1].y = points[2].y = y + height;

    hdc = GetDrawableDC(d);
    SetROP2(hdc, gc->function);
    hPen = CreatePen(gc->line_style, gc->line_width, gc->foreground);
    hPrevPen = SelectObject(hdc, hPen);
    Polyline(hdc, (POINT *)points, 5);
    DeleteObject(SelectObject(hdc, hPrevPen));
    ReleaseDrawableDC(d, hdc);
}

void FAR PASCAL
XFillRectangle(dummy, d, gc, x, y, width, height)
Display *dummy;
Drawable d;
GC gc;
int x, y;
unsigned int width, height;
{
    HDC hdc;
    HBRUSH hbr, hbrPrev;

    hdc = GetDrawableDC(d);
    SetROP2(hdc, gc->function);

    hbr = CreateSolidBrush(gc->foreground);
    if ((gc->fill_style == FillStippled || gc->fill_style == FillOpaqueStippled)
	    && gc->stipple != None) {
	HDC hdcMem;
	HBITMAP hbmp, hbmpPrev;
	HBRUSH hbrPat = 0, hbrPrevPat;

	hdcMem = CreateCompatibleDC(hdc);
	hbmp = CreateCompatibleBitmap(hdc, width, height);
	hbmpPrev = SelectObject(hdcMem, hbmp);
	hbrPrev = SelectObject(hdcMem, hbr);
	Rectangle(hdcMem, 0, 0, width, height );

	hbrPat = CreatePatternBrush(gc->stipple);
	hbrPrevPat = SelectObject(hdc, hbrPat);
//	BitBlt(hdc, x , y, width, height, hdcMem, 0, 0, SRCCOPY);
	BitBlt(hdc, x , y, width, height, hdcMem, 0, 0, 0x00AE0B06);

	BitBlt(hdc, x , y, width, height, hdcMem, 0, 0, 0x00A803A9);

	hbrPat = SelectObject(hdc, hbrPrevPat);
	DeleteObject(hbrPat);

	DeleteObject(SelectObject(hdcMem, hbrPrev));
	DeleteObject(SelectObject(hdcMem, hbmpPrev));
	DeleteDC(hdcMem);
    } else {
	HPEN hpen, hpenPrev;

	hpen = CreatePen(PS_SOLID, 1, gc->foreground);
	hpenPrev = SelectObject(hdc, hpen);
	hbrPrev = SelectObject(hdc, hbr);
	Rectangle(hdc, x, y, x + width, y + height );
	DeleteObject(SelectObject(hdc, hpenPrev));
	DeleteObject(SelectObject(hdc, hbrPrev));
    }
    ReleaseDrawableDC(d, hdc);
}

void FAR PASCAL 
XDrawString(display, d, gc, x, y, string, length)
Display *display;
Drawable d;
GC gc;
int x, y;
const char string[];
int length;
{
    HDC hdc, hdcMem;
    HBITMAP hbmp, hbmpPrev;
    HBRUSH hbr, hbrPrev;
    HFONT hfontPrev;
    SIZE sz;
    TEXTMETRIC tm;

    hdc = GetDrawableDC(d);
    SetROP2(hdc, gc->function);

    hdcMem = CreateCompatibleDC(hdc);
    if (gc->font != None) {
	hfontPrev = SelectObject(hdcMem, gc->font);
    }
    GetTextExtentPoint(hdcMem, string, length, &sz);
    GetTextMetrics(hdcMem, &tm);
    hbmp = CreateCompatibleBitmap(hdc, sz.cx + 10, sz.cy + 10);
    hbmpPrev = SelectObject(hdcMem, hbmp);
    SetTextAlign(hdcMem, TA_LEFT | TA_TOP);
    SetTextColor(hdcMem, gc->foreground);

    if ((gc->fill_style == FillStippled || gc->fill_style == FillOpaqueStippled)
	    && gc->stipple != None) {
	hbr = CreatePatternBrush(gc->stipple);
    } else {
	hbr= CreateSolidBrush(RGB(0, 0, 0));
    }

    PatBlt(hdcMem, 0, 0, sz.cx+10, sz.cy+10, BLACKNESS);
    SetBkColor(hdcMem, RGB(0, 0, 0));
    TextOut(hdcMem, 0, 0, string, length);

    hbrPrev = SelectObject(hdc, hbr);
/*    BitBlt(hdc, x , y - sz.cy, sz.cx, sz.cy, hdcMem, 0, 0, 0x00AE0B06); */
    BitBlt(hdc, x , y - tm.tmAscent, sz.cx, sz.cy, hdcMem, 0, 0, 0x00AE0B06); 

    PatBlt(hdcMem, 0, 0, sz.cx+10, sz.cy+10, WHITENESS);
    SetBkColor(hdcMem, RGB(255, 255, 255));
    TextOut(hdcMem, 0, 0, string, length);

/*    BitBlt(hdc, x , y - sz.cy, sz.cx, sz.cy, hdcMem, 0, 0, 0x00A803A9); */
    BitBlt(hdc, x , y - tm.tmAscent, sz.cx, sz.cy, hdcMem, 0, 0, 0x00A803A9); 
    hbr = SelectObject(hdc, hbrPrev);
    DeleteObject(hbr);

    if (gc->font != None)
	SelectObject(hdcMem, hfontPrev);
    DeleteObject(SelectObject(hdcMem, hbmpPrev));
    DeleteDC(hdcMem);
    
    ReleaseDrawableDC(d, hdc);

}

#ifdef KANJI 
void FAR PASCAL 
XDrawString16(display, d, gc, x, y, string, length)
Display *display;
Drawable d;
GC gc;
int x, y;
const XChar2b *string;
int length;
{
    char *bp;
    char *buffer;
    XChar2b *wp;
    XChar2b *cp;
    int cnt = 0, i;
    BYTE c1, c2;

    cp = (XChar2b *) malloc(sizeof(XChar2b) * length);
    memcpy(cp, string, sizeof(XChar2b) * length); 
    for(i = 0, wp = cp;  (wp->byte2 != 0) && (i < length); wp++, i++) {
	if (wp->byte1) {
	    c2 = wp->byte2;
	    c1 = wp->byte1;
	    wp->byte1 = (c1 - 0x21) / 2 + ((c1 <= 0x5e) ? 0x81 : 0xc1);
	    if( c1 & 1 ) {	/* odd */
		wp->byte2 = c2 + ((c2 <= 0x5f) ? 0x1f : 0x20);
	    } else {
		wp->byte2 = c2 + 0x7e;
	    }
	    cnt += 2;
	} else {
	    cnt++;
	}
    }
    buffer = (char *) malloc(cnt + 1);
    for(i = 0, wp = cp, bp = buffer;(wp->byte2 != 0) && ( i < length); wp++, i++) {
	if (_ismbblead(wp -> byte1)) {
	    *bp++ = wp -> byte1;
	    *bp++ = wp -> byte2;
	} else {
	    *bp++ = wp -> byte2;
	}
    }
    *bp = '\0';    	
    XDrawString(display, d, gc, x, y, buffer, cnt);
    free(buffer);
    free(cp);
}
#endif /* KANJI */ 
