/*
 * xfont.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc. 
 * 
 */
 
#include <X11/Xlib.h>
#include <x11/xutil.h>
#include <stdlib.h>
#include <string.h>
#ifdef KANJI 
#include <mbstring.h>
#endif /* KANJI */
#include <memory.h>

static LOGFONT * NEAR PASCAL
NameToLogFont(const char *name, LOGFONT * lplf)
{
    const char *pHead, *pTail;
#ifdef KANJI
    const char *lp;
#endif /* KANJI */

    memset(lplf, '\0', sizeof(LOGFONT));

    pHead = name;
#ifdef KANJI
    if ((pTail = (char *) _mbschr((const unsigned char *) pHead, '-')) == NULL) 
    	goto default_font;
    strncpy(lplf->lfFaceName, pHead, pTail - pHead);

    lplf->lfCharSet= ANSI_CHARSET;
    for (lp = pHead; lp != pTail; lp++) {
    	if (_ismbblead((unsigned char) *lp)) {
    	    lplf->lfCharSet= SHIFTJIS_CHARSET;
	    break;
	}
    }

    pHead = pTail + 1;

    if ((pTail = (char *) _mbschr((const unsigned char *) pHead, '-')) == NULL) 
    	goto default_font;
#else
    if ((pTail = strchr((const unsigned char *) pHead, '-')) == NULL) 
    	goto default_font;
    strncpy(lplf->lfFaceName, pHead, pTail - pHead);

    lplf->lfCharSet= ANSI_CHARSET;

    pHead = pTail + 1;

    if ((pTail = strchr((const unsigned char *) pHead, '-')) == NULL) 
    	goto default_font;
#endif
    lplf->lfWeight = strstr(pHead, "Bold")? FW_BOLD: FW_MEDIUM;
    lplf->lfItalic = strstr(pHead, "Italic") != NULL;
    pHead = pTail + 1;    

    if ((lplf->lfHeight = atoi(pHead)) <=0) 
    	goto default_font;

    return lplf;

default_font:    
    lplf->lfHeight = 14;
    return lplf;
}

XFontStruct * FAR PASCAL
XLoadQueryFont(Display *dummy, const char *name)
{
	XFontStruct *fs = (XFontStruct *)malloc(sizeof(XFontStruct));
	LOGFONT lf;
	HDC hdc;
	HFONT hfont_old;
	TEXTMETRIC tm;
	XCharStruct cs;
	memset(fs, 0, sizeof(XFontStruct)); 
	fs->fid = CreateFontIndirect(NameToLogFont(name, &lf) );
	hdc = CreateCompatibleDC((HDC)NULL);
	hfont_old = SelectObject( hdc, fs->fid );

	GetTextMetrics( hdc, &tm );
/*
	fs->direction = (lf.lfEscapement == 900? FontRightToLeft: FontLeftToRight);
*/
	fs->min_byte1 = fs->max_byte1 = 0;
	fs->min_char_or_byte2 = tm.tmFirstChar;
	fs->max_char_or_byte2 = tm.tmLastChar;
	fs->all_chars_exist = TRUE;
	fs->default_char = tm.tmDefaultChar;

	    fs->ascent = tm.tmAscent;
	    fs->descent = tm.tmDescent;
	cs.width = tm.tmAveCharWidth;
	cs.ascent = fs->ascent;
	cs.descent = fs->descent;
	cs.lbearing = 0;
	cs.rbearing = cs.width;
	fs->min_bounds = fs->max_bounds = cs;
	fs->per_char = NULL;

	if( tm.tmAveCharWidth != tm.tmMaxCharWidth ) {
		int i, nchars = tm.tmLastChar - tm.tmFirstChar + 1;
		int *wbuf = (int *)malloc(sizeof(int) * nchars);
		int min_width = 30000;

			GetCharWidth( hdc, tm.tmFirstChar, tm.tmLastChar, (int FAR *)wbuf );

		fs->per_char = (XCharStruct *)malloc(sizeof(XCharStruct) * nchars);
		for( i = 0; i < nchars ; i++ ) {
			fs->per_char[i] = cs;
			fs->per_char[i].width = wbuf[i];
			if( min_width > wbuf[i] )
				min_width = wbuf[i];
		}
		fs->max_bounds.width = tm.tmMaxCharWidth;
		fs->min_bounds.width = min_width;
		/* fs->min_bounds.width = tm.tmAvgCharWidth * 2 - tm.tmMaxCharWidth;*/
	}

	SelectObject( hdc, hfont_old );
	DeleteDC( hdc );

	return fs;
}

void FAR PASCAL
XFreeFont(Display *dummy, XFontStruct *font_struct)
{
	if( font_struct->per_char )
		free( font_struct->per_char );
	DeleteObject(font_struct->fid);
	free(font_struct);
}

Bool FAR PASCAL
XGetFontProperty(XFontStruct *dummy1, Atom dummy2, 
	unsigned long *dummy3)
{
	/* is used only for getting XA_UNDERLINE_{POSITION&THICKNESS} value
	 * in tkFont.c:TkUnderlineChars()
	 */
	return FALSE;
}

void FAR PASCAL
XTextExtents(XFontStruct *font_struct, const char *string, int nchars, 
	int *direction_return, int *ascent_return, int *descent_return, 
	XCharStruct *overall_return)
{
	HDC hdc;
	HFONT hfont_old;
	TEXTMETRIC tm;

	*direction_return = font_struct->direction;
	*ascent_return = font_struct->ascent;
	*descent_return = font_struct->descent;

	hdc = CreateCompatibleDC((HDC)NULL);
	hfont_old = SelectObject( hdc, font_struct->fid );

	GetTextMetrics( hdc, &tm );
	overall_return->ascent = tm.tmAscent;
	overall_return->descent = tm.tmDescent;
	overall_return->width = LOWORD(GetTextExtent( hdc, string, nchars ));
	overall_return->lbearing = 0;
	overall_return->rbearing = overall_return->width;

	SelectObject( hdc, hfont_old );
	DeleteDC( hdc );
}

int FAR PASCAL
XTextWidth(XFontStruct *font_struct, const char *string, int count)
{
	HDC hdc;
	HFONT hfont_old;
	int text_width;
	int one, two;

	hdc = GetDC((HWND)NULL);
	hfont_old = SelectObject( hdc, font_struct->fid );
	one = LOWORD(GetTextExtent( hdc, "a", 1 ));
	two = LOWORD(GetTextExtent( hdc, "aa", 2 ));
	text_width = LOWORD(GetTextExtent( hdc, string, count ));
	text_width = text_width - (one * 2 - two);
	SelectObject( hdc, hfont_old );
	ReleaseDC((HWND) NULL,  hdc );

	return text_width;
}
 
#ifdef KANJI
int FAR PASCAL
XTextWidth16(XFontStruct *font_struct, const XChar2b *string, int count)
{
    char *bp;
    char *buffer;
    XChar2b *cp;
    XChar2b *wp;
    int cnt = 0, i, result;
    BYTE c1, c2;

    cp = (XChar2b *) malloc(sizeof(XChar2b) * count);
    memcpy(cp, string, sizeof(XChar2b) * count); 
    for(i = 0, wp = cp; (wp->byte2 != 0) && (i < count); wp++, i++) {
	if (wp->byte1) {
	    c2 = wp->byte2;
	    c1 = wp->byte1;
	    wp->byte1 = (c1 - 0x21) / 2 + ((c1 <= 0x5e) ? 0x81 : 0xc1);
	    if( c1 & 1 ) {	/* odd */
		wp->byte2 = c2 + ((c2 <= 0x5f) ? 0x1f : 0x20);
	    } else {
		wp->byte2 = c2 + 0x7e;
	    }
	    cnt += 2;
	} else {
	    cnt++;
	}
    }
    buffer = (char *) malloc(cnt + 1);
    for(i = 0, wp = cp, bp = buffer;(wp->byte2 != 0) && ( i < count); wp++, i++) {
	if (_ismbblead(wp -> byte1)) {
	    *bp++ = wp -> byte1;
	    *bp++ = wp -> byte2;
	} else {
	    *bp++ = wp -> byte2;
	}
    }
    *bp	= '\0';
    result = XTextWidth(font_struct, buffer, cnt);
    free(buffer);
    free(cp);
    return result;
}
 
void FAR PASCAL
XTextExtents16(XFontStruct *font_struct, const XChar2b *string, int nchars,
	int *direction_return, int *ascent_return, int *descent_return,
	XCharStruct *overall_return)
{
    char *bp;
    char *buffer;
    XChar2b *wp;
    XChar2b *cp;
    int cnt = 0, i;
    BYTE c1, c2;

    cp = (XChar2b *) malloc(sizeof(XChar2b) * nchars);
    memcpy(cp, string, sizeof(XChar2b) * nchars); 
    for(i = 0, wp = cp; (wp->byte2 != 0) && (i < nchars); wp++, i++) {
	if (wp->byte1) {
	    c2 = wp->byte2;
	    c1 = wp->byte1;
	    wp->byte1 = (c1 - 0x21) / 2 + ((c1 <= 0x5e) ? 0x81 : 0xc1);
	    if( c1 & 1 ) {	/* odd */
		wp->byte2 = c2 + ((c2 <= 0x5f) ? 0x1f : 0x20);
	    } else {
		wp->byte2 = c2 + 0x7e;
	    }
	    cnt += 2;
	} else {
	    cnt++;
	}
    }
    buffer = (char *) malloc(cnt + 1);
    for(i = 0, wp = cp, bp = buffer;(wp->byte2 != 0) && ( i < nchars); wp++, i++) {
	if (_ismbblead(wp -> byte1)) {
	    *bp++ = wp -> byte1;
	    *bp++ = wp -> byte2;
	} else {
	    *bp++ = wp -> byte2;
	}
    }
    *bp	= '\0';
    XTextExtents(font_struct, buffer, cnt, direction_return, ascent_return,
	descent_return, overall_return);
    free(buffer);
    free(cp);
}
#endif /* KANJI */ 

