/*
 * xdefcur.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#include <X11/Xlib.h>
#include "wndproc.h"
#include "util.h"

void FAR PASCAL
XDefineCursor(Display *dummy, Window w, Cursor cursor)
{
    POINT pt;
    XSetWindowAttributes attrs;
    unsigned char result;

    attrs.cursor = cursor;
    result = _SetWindowAttributes(w, CWCursor, &attrs);
    if (result != Success) {
	postError(result, w);
	return;
    }
    GetCursorPos(&pt);
    SetCursorPos(pt.x, pt.y);
}

void  FAR PASCAL
XUndefineCursor(Display *dummy, Window w)
{
    POINT pt;
    XSetWindowAttributes attrs;
    unsigned char result;

    attrs.cursor = GetWindowWord(w, HPCS_OFFSET); 
    result = _SetWindowAttributes(w, CWCursor, &attrs);
    if (result != Success) {
	postError(result, w);
	return;
    }
    SetWindowWord(w, HPCS_OFFSET, NULL);
    GetCursorPos(&pt);
    SetCursorPos(pt.x, pt.y);
}

