/*
 * xcreatew.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "wndproc.h"
#include "util.h"

/*
 *	XCreateWindow
 *
 */
 	
Window FAR PASCAL													
XCreateWindow(Display *dummy1, Window parent, int x, int y, UINT width, 
	UINT height, UINT border_width, int dummy2, UINT dummy3, 
	Visual *dummy4, unsigned long valuemask, 
	XSetWindowAttributes *attributes)
{
    HWND child;
    DWORD dwStyle;
    XWindowChanges changes;
    BYTE byResult;
    	
    if (parent == NULL) {
        RECT rc;
    	if (attributes->override_redirect == True) {

	    dwStyle = WS_POPUP|WS_BORDER|WS_CLIPCHILDREN;
	} else {
	    dwStyle = WS_OVERLAPPEDWINDOW|WS_CLIPCHILDREN;
	}
	child = CreateWindow("TopLevel", "", dwStyle, 
		attributes->override_redirect?x:CW_USEDEFAULT, 
		attributes->override_redirect?y:CW_USEDEFAULT, 
		AdjustWidth(width, attributes->override_redirect),
		AdjustHeight(height, attributes->override_redirect), 
    		parent, NULL, GetAppInstance(), NULL);
	GetWindowRect(child, &rc);
	y = ReAdjustY(rc.top, attributes->override_redirect);
	x = ReAdjustX(rc.left, attributes->override_redirect);
    } else {
	dwStyle = WS_CHILD|WS_CLIPCHILDREN|WS_CLIPSIBLINGS;
	child = CreateWindow("Widget", "", dwStyle, x, y, width, height, 
    		parent, NULL, GetAppInstance(), NULL);
    }

    if (child == NULL) {
	postError(BadWindow, parent);
	return NULL;
    }

    byResult = _SetWindowAttributes(child, valuemask, attributes);
    if (byResult != Success) {
	goto destroy;
    }

    changes.x = x;
    changes.y = y;
    changes.width = width;
    changes.height = height;
    changes.border_width = border_width;
    byResult = _SetWindowChanges(child, CWX|CWY|CWWidth|CWHeight|CWBorderWidth, &changes);
    if (byResult != Success) {
	destroy:
	DestroyWindow(child);
	postError(byResult, parent);
	return NULL;
    }

    return child;
}

/* 
 *	XDestroyWindow
 *
 */

void   FAR PASCAL
XDestroyWindow(Display *dummy, Window hwnd)
{
    if (DestroyWindow(hwnd) == 0) {;
	postError(BadWindow, hwnd);
    }
}


/*
 *	XMapWindow
 *	
 *
 */

void	 FAR PASCAL
XMapWindow(Display *dummy, Window w)
{
    HGLOBAL hGlobal;
    XWMHints *hPtr;

    if ((hGlobal = GetProp(w, "XA_WM_HINTS")) != NULL) {
	int state;
	long flags;

	hPtr = (XWMHints *) GlobalLock(hGlobal);
	flags = hPtr->flags;
	state = hPtr->initial_state;
	GlobalUnlock(hGlobal);
	if(flags & StateHint) {
	    switch(state) {
	    case NormalState:
		goto normalmap;
	    case IconicState:
		ShowWindow(w, SW_SHOWMINNOACTIVE); break;
	    case WithdrawnState:
		ShowWindow(w, SW_HIDE); break;
	    }
	} 
    } else {	    	
	normalmap:
	ShowWindow(w, SW_SHOWNA);
	PostMessage(w, MAPNOTIFY, 0, 0L);
    }
}


/*
 *	XUnmapWindow
 *
 */

void   FAR PASCAL
XUnmapWindow(Display *dummy, Window hwnd)
{
    ShowWindow(hwnd, SW_HIDE);
    PostMessage(hwnd, UNMAPNOTIFY, 0, 0L);
}

/*
 *	XIconifyWindow
 *
 */

Status FAR PASCAL
XIconifyWindow(Display *dummy1, Window hwnd, int dummy2)
{
    ShowWindow(hwnd, SW_SHOWMINNOACTIVE);
    PostMessage(hwnd, UNMAPNOTIFY, 0, 0L);
    return 1;
}

/*
 *	XWithdrawWindow
 *
 */

Status FAR PASCAL
XWithdrawWindow(Display *dummy1, Window hwnd, int dummy2)
{
    ShowWindow(hwnd, SW_HIDE);
    PostMessage(hwnd, UNMAPNOTIFY, 0, 0L);
    return 1;
}

