/*
 * xatom.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <X11/Xlib.h>
#include <stdlib.h>
#include <string.h>

Atom FAR PASCAL
XInternAtom(Display *dummy, const char *atom_name, Bool exists)
{
    Atom atom;
    if (exists == True) {
	return  GlobalFindAtom(atom_name);
    } else {
	if ((atom = GlobalFindAtom(atom_name)) != 0) {
	    return atom;
	} else {
	    return GlobalAddAtom(atom_name);
	}
    }
}

char * FAR PASCAL
XGetAtomName(Display *dummy, Atom atom)
{
    char buffer[256];
    char *p;
    int len;

    len = (int) GlobalGetAtomName(atom, buffer, sizeof(buffer));
    if ((p = malloc(len + 1)) == NULL) {
    	return NULL;
    } else {
    	strcpy(p, buffer);
    }
    return p;
}
