/*
 * window.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <X11/Xlib.h>
#include "wndproc.h"
#include "util.h"

extern HCURSOR hDefaultCursor;

static void NEAR ReStack(HWND, HWND, int);

/*
 * _SetWindowChanges
 *
 */

unsigned char NEAR PASCAL
_SetWindowChanges(Window w, unsigned long mask, XWindowChanges * changes)
{
    XWindowChanges * pXWChanges;
    HGLOBAL hXWChanges;
    XSetWindowAttributes * pXSWAttrs;
    HGLOBAL hXSWAttrs;
    HWND hwnd = (HWND) w;
    UINT flag = SWP_NOACTIVATE|SWP_NOMOVE|SWP_NOZORDER|SWP_NOSIZE;

    hXWChanges = GetWindowWord(hwnd, XWCH_OFFSET);
    if ((pXWChanges = (XWindowChanges *) GlobalLock(hXWChanges)) == NULL) {
    	return BadWindow;
    }
    hXSWAttrs = GetWindowWord(hwnd, XSWA_OFFSET);
    if ((pXSWAttrs = (XSetWindowAttributes *) GlobalLock(hXSWAttrs)) == NULL) {
    	return BadWindow;
    }

    if (mask & CWX) {
	pXWChanges->x = changes->x;
	flag &= ~SWP_NOMOVE;
    }
    if (mask & CWY) {
	pXWChanges->y = changes->y;
	flag &= ~SWP_NOMOVE;
    }
    if (mask & CWWidth)	{
    	pXWChanges->width = changes->width;
	flag &= ~SWP_NOSIZE;
    }
    if (mask & CWHeight) {
    	pXWChanges->height = changes->height;
	flag &= ~SWP_NOSIZE;
    }
    if (mask & CWBorderWidth)	pXWChanges->border_width = changes->border_width;
    if (mask & CWSibling)      	pXWChanges->sibling = changes->sibling;
    if (mask & CWStackMode)    	pXWChanges->stack_mode = changes->stack_mode;
 	
    if (GetParent(hwnd) == HWND_DESKTOP) {
	MoveWindow(hwnd, 
		AdjustX(pXWChanges->x, pXSWAttrs->override_redirect),
		AdjustY(pXWChanges->y, pXSWAttrs->override_redirect),
   		AdjustWidth(pXWChanges->width, pXSWAttrs->override_redirect), 
   	    	AdjustHeight(pXWChanges->height, pXSWAttrs->override_redirect), TRUE);

    } else {
   	MoveWindow(hwnd, pXWChanges->x, pXWChanges->y, 
   		pXWChanges->width, pXWChanges->height, TRUE);
    }

    if (mask &CWStackMode) {
    	ReStack(hwnd, (HWND) (mask&CWSibling?pXWChanges->sibling:None), pXWChanges->stack_mode);
    }

    GlobalUnlock(hXWChanges);
    GlobalUnlock(hXSWAttrs);
    return Success;
}

static void NEAR
ReStack(HWND hwnd, HWND hwndSibling, int mode)
{
    HWND hwndInsertAfter;

    if (hwndSibling == None) {
	hwndInsertAfter = (mode == Above) ? HWND_TOP : HWND_BOTTOM;
    } else {
        if (mode == Above) {
	    SetWindowPos(hwnd, hwndSibling, 0, 0, 0, 0, 
	    	    SWP_NOACTIVATE|SWP_NOMOVE|SWP_NOSIZE);
	    hwndInsertAfter = hwnd;
	    hwnd = hwndSibling;
        } else {
	    hwndInsertAfter = hwndSibling;
	}
    }
    SetWindowPos(hwnd, hwndInsertAfter, 0, 0, 0, 0, 
	    SWP_NOACTIVATE|SWP_NOMOVE|SWP_NOSIZE);
}


/* 
 * _SetWindowAttributes
 *
 */

unsigned char NEAR PASCAL 
_SetWindowAttributes(Window w, unsigned long mask, XSetWindowAttributes * attrs)
{
    XSetWindowAttributes * pXSWAttrs;
    HGLOBAL hXSWAttrs;
    HWND hwnd = (HWND) w;
    hXSWAttrs = GetWindowWord(hwnd, XSWA_OFFSET);
    if ((pXSWAttrs = (XSetWindowAttributes *) GlobalLock(hXSWAttrs)) == NULL) {
    	return BadWindow;
    }

    if (mask & CWBackPixmap)		pXSWAttrs->background_pixmap = attrs->background_pixmap;
    if (mask & CWBackPixel)             pXSWAttrs->background_pixel = attrs->background_pixel;
    if (mask & CWBorderPixmap)          pXSWAttrs->border_pixmap = attrs->border_pixmap;
    if (mask & CWBorderPixel)           pXSWAttrs->border_pixel = attrs->border_pixel;
    if (mask & CWBitGravity)            pXSWAttrs->bit_gravity = attrs->bit_gravity;
    if (mask & CWWinGravity)            pXSWAttrs->win_gravity = attrs->win_gravity;
    if (mask & CWBackingStore)          pXSWAttrs->backing_store = attrs->backing_store;
    if (mask & CWBackingPlanes)         pXSWAttrs->backing_planes = attrs->backing_planes;
    if (mask & CWBackingPixel)          pXSWAttrs->backing_pixel = attrs->backing_pixel;
    if (mask & CWOverrideRedirect)	pXSWAttrs->override_redirect = attrs->override_redirect;
    if (mask & CWSaveUnder)             pXSWAttrs->save_under = attrs->save_under;
    if (mask & CWEventMask)             pXSWAttrs->event_mask = attrs->event_mask;
    if (mask & CWDontPropagate)         pXSWAttrs->do_not_propagate_mask = attrs->do_not_propagate_mask;
    if (mask & CWColormap)              pXSWAttrs->colormap = attrs->colormap;
    if (mask & CWCursor) {
    	SetWindowWord(hwnd, HPCS_OFFSET, (WORD) pXSWAttrs->cursor);  
	SetWindowWord(hwnd, HCCS_OFFSET, (WORD) attrs->cursor);
	pXSWAttrs->cursor = attrs->cursor;
    }

    GlobalUnlock(hXSWAttrs);

    return Success;
}
