/*
 * widgproc.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <x11/xlib.h> 
#include <string.h>
#include "wndproc.h"	
#include "util.h"

extern XSetWindowAttributes defAttrs;
extern XWindowChanges defChanges;

/* 
 *	RegisterWidgetClass -- 
 *	
 */

void
__far __pascal
RegisterWidgetClass(HINSTANCE hInstance)
{
    WNDCLASS wndclass;

    wndclass.style	   = CS_HREDRAW  | CS_VREDRAW;
    wndclass.lpfnWndProc   = WidgetProc;
    wndclass.cbClsExtra    = 0;
    wndclass.cbWndExtra    = 32;
    wndclass.hInstance     = hInstance;
    wndclass.hIcon	   = LoadIcon(0, IDI_APPLICATION);
    wndclass.hCursor       = NULL;
    wndclass.hbrBackground = NULL;
    wndclass.lpszMenuName  = NULL;
    wndclass.lpszClassName = "Widget";

    RegisterClass(&wndclass);
}

/*
 *	WidgetProc --
 *
 */

long FAR PASCAL
WidgetProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    HGLOBAL hXSWAttrs, hXWChanges;
    XSetWindowAttributes * pXSWAttrs;
    XWindowChanges * pXWChanges;
    HGLOBAL hwp;
    WINDOWPOS FAR * lpwp;
    HCURSOR hcs;
    static int flag = 0;

    switch(message) {
    case WM_CREATE:
    	hXSWAttrs = GlobalAlloc(GHND, sizeof(XSetWindowAttributes));
	pXSWAttrs = (XSetWindowAttributes *) GlobalLock(hXSWAttrs);
	memcpy(pXSWAttrs, &defAttrs, sizeof(XSetWindowAttributes));
	GlobalUnlock(hXSWAttrs);

	hXWChanges = GlobalAlloc(GHND, sizeof(XWindowChanges));
	pXWChanges = (XWindowChanges *) LocalLock(hXWChanges);
	memcpy(pXWChanges, &defChanges, sizeof(XWindowChanges));
	GlobalUnlock(hXWChanges);

    	SetWindowWord(hwnd, XSWA_OFFSET, (WORD) hXSWAttrs);
	SetWindowWord(hwnd, XWCH_OFFSET, (WORD) hXWChanges);

	PostMessage(hwnd, CREATENOTIFY,  wParam, lParam); 
	return 0;

    case WM_ACTIVATE:
    	PostMessage(hwnd, EXPOSE, 0, 0L);
	return 0;

    case WM_SETFOCUS:
	PostMessage(hwnd, FOCUSIN, wParam, lParam); 
	return 0;
	
    case WM_KILLFOCUS:
	PostMessage(hwnd, FOCUSOUT, wParam, lParam); 
	return 0;

    case WM_WINDOWPOSCHANGED:
    	hwp = GlobalAlloc(LHND, sizeof(WINDOWPOS));
	lpwp = (WINDOWPOS *) GlobalLock(hwp);
	memcpy(lpwp, (WINDOWPOS *)lParam, sizeof(WINDOWPOS));
	GlobalUnlock(hXWChanges);

	hXWChanges = GetWindowWord(hwnd, XWCH_OFFSET);
	pXWChanges = (XWindowChanges *) GlobalLock(hXWChanges);

	if (lpwp->flags & SWP_NOMOVE) {
	     lpwp->x = pXWChanges->x;
	     lpwp->y = pXWChanges->y;
	} else {
	     pXWChanges->x = lpwp->x;
	     pXWChanges->y = lpwp->y;
	}
	if (lpwp->flags & SWP_NOSIZE) {
	     lpwp->cx = pXWChanges->width;
	     lpwp->cy = pXWChanges->height;
	} else {
	     pXWChanges->width = lpwp->cx;
	     pXWChanges->height = lpwp->cy;
	}

	GlobalUnlock(hwp);
	PostMessage(hwnd, CONFIGURENOTIFY, hwp, 0L); 
	return 0;

    case WM_MOUSEMOVE: 
    	if ((hcs = GetWindowWord(hwnd, HCCS_OFFSET)) == NULL) {
	    hcs = FindCursor(hwnd);
	    SetWindowWord(hwnd, HCCS_OFFSET, (WORD) hcs);
	}
	SetCursor(hcs);				    
	return 0;

    case WM_DESTROY: 
    	GlobalFree(GetWindowWord(hwnd, XSWA_OFFSET));
	GlobalFree(GetWindowWord(hwnd, XWCH_OFFSET));
	EnumProps(hwnd, ClearProps);
	return 0;

    case WM_USER+1:
        flag = 1;
	return 0;

    case WM_DESTROYCLIPBOARD:
        if (flag) {
	    flag = 0;
	    return 0;
	}
	PostMessage(hwnd, SELECTIONCLEAR, wParam, lParam);
	return 0; 
    }
    DefWindowProc(hwnd, message, wParam, lParam);
}

			