/*
 * lxlib.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <windows.h>
#include "util.h"

extern int cxChar, cyChar;
extern int cxFrame, cyFrame, cyCaption, cxVScroll;
extern int cxDiff, cyDiff;

int FAR PASCAL
LibMain(HINSTANCE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpCmdLine)
{
    HDC hdc;
    TEXTMETRIC tm;

    SetClearProps(hInstance);
    SetDefaultCursor(LoadCursor(0, IDC_ARROW));
    InitAdjustment();

	hdc = GetDC((HWND) 0);
	SelectObject(hdc, GetStockObject(SYSTEM_FIXED_FONT));
	GetTextMetrics(hdc, &tm);
	ReleaseDC((HWND) 0, hdc);
	cxChar = tm.tmAveCharWidth;
	cyChar = tm.tmHeight;
	cxFrame = GetSystemMetrics(SM_CXFRAME);
	cyFrame = GetSystemMetrics(SM_CYFRAME);
	cyCaption = GetSystemMetrics(SM_CYCAPTION);
	cxVScroll = GetSystemMetrics(SM_CXVSCROLL);
	cxDiff = cxFrame * 2;
	cyDiff = cyCaption + (cyFrame * 2);

    if (wHeapSize > 0) {
	UnlockData(0);
    }

    return 1;
}

int FAR PASCAL 
WEP(int nParam)
{
    if (nParam == WEP_SYSTEM_EXIT) {
    	return 1;
    } else if (nParam == WEP_FREE_DLL) {
	return 1;
    }
    return 1;
}
