/*
 * cursor.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#include "util.h"
#include "wndproc.h"

static HCURSOR hDefaultCursor;

void NEAR PASCAL
SetDefaultCursor(HCURSOR hcs)
{
    hDefaultCursor = hcs;
}

HCURSOR NEAR PASCAL
GetDefaultCursor(void)
{
    return hDefaultCursor;
}

HCURSOR NEAR PASCAL
FindCursor(HWND hwnd)
{
    HCURSOR hcs;

    if (hwnd == HWND_DESKTOP) 
    	return hDefaultCursor;
     
    if ((hcs = GetWindowWord(hwnd, HCCS_OFFSET)) != NULL)
	return hcs;

   return FindCursor(GetParent(hwnd));
}
