/*
 * chain.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <stdlib.h>
#include <string.h>
#include "wndproc.h"
#include "util.h"

XEvent * NEAR PASCAL
peekEvent(_XQEvent *chain, XEvent *event)	
{
    if (chain == NULL) return NULL;

    memcpy(event, &chain->event, sizeof(XEvent));
    return event;
}

_XQEvent * NEAR PASCAL
discardEvent(_XQEvent *chain)
{
    _XQEvent *cPtr;

    cPtr = chain->next;
    free(chain);
    return cPtr;
}

_XQEvent * NEAR PASCAL
putEvent(XEvent *event, _XQEvent *chain)
{
    _XQEvent * cPtr;
    
    if (chain != NULL) {
	chain->next = putEvent(event, chain->next);
	return chain;
    }

    if ( (cPtr = (_XQEvent *)malloc(sizeof(_XQEvent))) == NULL ) return NULL;
    cPtr->next = NULL;
    memcpy(&cPtr->event, event, sizeof(XEvent));
    return cPtr;
}

