/* 
 * stdio.c
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#include <windows.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include "term.h"

#undef stdin
#undef stdout
#undef stderr
#define stdin  (FILE *)0
#define stdout (FILE *)1
#define stderr (FILE *)2

#define BUFFER_LENGTH 1024

int _cdecl
TbPrintf(char * format, ...)
{
    char buffer[BUFFER_LENGTH + 1];
    int result;
    va_list arg_ptr;

    va_start(arg_ptr, format);
    if((result = vsprintf(buffer, format, arg_ptr)) > 0){
        buffer[BUFFER_LENGTH] = '\0';
	wputs(buffer, GetTbWindow());
    }
    va_end(arg_ptr);
    return result;
} 

int 
TbFprintf(FILE *fp, char *format, ...)
{
    char buffer[BUFFER_LENGTH + 1];
    int result;
    va_list arg_ptr;

    va_start(arg_ptr, format);
    if (fp == stdin) {
    	result = -1;
    } else if(fp == stdout || fp == stderr) {  
    	result = vsprintf(buffer, format, arg_ptr);
	wputs(buffer, GetTbWindow());
    } else {
	result =vfprintf(fp, format, arg_ptr);
    }
    va_end(arg_ptr);
    return result;
}

int 
TbFputc(char ch, FILE *fp)
{
    if (fp == stdout || fp == stderr) {
	SendMessage(GetTbWindow(), WM_USER+20, (WPARAM)ch, 0L);
	return ch;
    }
    return fputc(ch, fp);
}

int 
TbFputs(const char *string, FILE *fp)
{
    if (fp == stdout || fp == stderr) {
    	wputs(string,  GetTbWindow());
	return 1;
    }
    return fputs(string, fp);
}

void 
TbClearerr(FILE *fp)
{
    if (fp == stdin || fp == stdout || fp == stderr) {
	return;
    }
    clearerr(fp);
}

      
int 
TbFileno(FILE *fp)		 
{
    if (fp == stdin || fp == stdout || fp == stderr) {
	return (int) (long) fp;
    }
    return fileno(fp);
}

int 
TbFerror(FILE *fp)
{
    if (fp == stdin || fp == stdout || fp == stderr) {
	return 0;
    }
    return ferror(fp);
}

int 
TbFeof(FILE *fp)
{
    if (fp == stdin || fp == stdout || fp == stderr) {
	return 0;
    }
    return feof(fp);
}

int 
TbFflush(FILE *fp)
{
    if (fp == stdin || fp == stdout || fp == stderr) {
	return 0;
    }
    return fflush(fp);
}

char *
TbFgets(char *buffer, int length, FILE *fp)
{
    if (fp == stdin) {
    	MSG msg;
    	
	while (GetMessage(&msg, (HWND) NULL, 0, 0)) {
	    if (msg.message == WM_USER) {
	        HGLOBAL hGlobal;
		char * pGlobal;
	        hGlobal = GetWindowWord(GetTbWindow(), 0);
		pGlobal = GlobalLock(hGlobal);
		strncpy(buffer, pGlobal, length);
		*pGlobal = '\0';
		GlobalUnlock(hGlobal);
		return buffer;
	    } else {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	    }
	}
	return NULL;
    } else {
    	return fgets(buffer, length, fp);
    }
}

int
TbFgetc(FILE *fp)
{
    HGLOBAL hGlobal;
    char * pGlobal;
    MSG msg;

    if (fp == stdin) {
	return_ch:
    	
        hGlobal = GetWindowWord(GetTbWindow(), 0);
	pGlobal = GlobalLock(hGlobal);
        if (*pGlobal != '\0') {
	    int ch;

	    ch = *pGlobal;
	    strcpy(pGlobal, pGlobal+1);
	    GlobalUnlock(hGlobal);
	    return ch;
	}
	GlobalUnlock(hGlobal);

	while (GetMessage(&msg, (HWND) NULL, 0, 0)) {
	    if (msg.message == WM_USER) {
		goto return_ch;
	    } else {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	    }
	}
	return EOF;
    } else {
    	return fgetc(fp);
    }
}
