/* 
 * tbscan.h
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#include <stdarg.h>
#include <stdio.h>
#define Getch tGetch
#define Ungetch tUngetch

#define NCHAR (EOF-1)
#define BUFFER_LEN 512

typedef struct {
    va_list ap;
    char **str;
    int nget;
    int nchar;
    int result;
} sinfo;

int tGetch(sinfo *);
int Getnch(sinfo *);
void tUngetch(sinfo *, int);
void Ungetnch(sinfo *, int);

int _cdecl getint      (char *, int , int *, sinfo *);
int _cdecl convint     (char *, char , char , int, sinfo *);
int _cdecl getfloat     (char *, int, sinfo *);
int _cdecl convfloat   (char *, char, sinfo *);

int _cdecl TbSscanf	(char *, char *, ...);
char * _cdecl convert  (int, int, char, char *, sinfo *);
int _cdecl isDigits	(char, int);
int _cdecl getBase	(char);

