/* 
 * tbgetflo.c
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#include "tbscan.h"
#include <ctype.h>

int
getfloat(char *buffer, int width, sinfo *sp)
{
    char *pb;
    char ch;
    int exist = 0;

    sp->nget = (width <= 0 || BUFFER_LEN < width) ? BUFFER_LEN : width;
    pb = buffer;
    ch = Getnch(sp);
    if (ch == '+' || ch == '-') {
	*pb++ = ch;
	ch = Getnch(sp);
    }
    while (isdigit(ch)) {
	*pb++ = ch;
	ch = Getnch(sp);
	exist = 1;
    }
    if (ch == '.') {
	*pb++ = ch;
	ch = Getnch(sp);
    }
    while (isdigit(ch)) {
	*pb++ = ch;
	ch = Getnch(sp);
	exist = 1;
    }
    if ((ch == 'e' || ch == 'E') && exist) {
	*pb++ = ch;
	ch = Getnch(sp);
	if (ch == '+' || ch == '-') {
	    *pb++ = ch;
	    ch = Getnch(sp);
	}
	for (exist = 0; isdigit(ch); exist = 1) {
	    *pb++ = ch;
	    ch = Getnch(sp);
	}
    }
    Ungetnch(sp, ch);
    *pb = '\0';
    return exist;
}

