/*
 * util.h
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#ifndef _X_LIB_H_
#include <X11/Xlib.h>
#endif

/* adjust.c */
extern void 	NEAR PASCAL 	InitAdjustment(void);
extern int 	NEAR PASCAL 	AdjustWidth(int, int);
extern int 	NEAR PASCAL 	AdjustHeight(int, int);
extern int	NEAR PASCAL	ReAdjustWidth(int, int);
extern int	NEAR PASCAL	ReAdjustHeight(int, int);
extern int	NEAR PASCAL 	AdjustX(int, int);
extern int	NEAR PASCAL 	AdjustY(int, int);
extern int	NEAR PASCAL	ReAdjustX(int, int);
extern int	NEAR PASCAL	ReAdjustY(int, int);

/* callback.c */
extern	BOOL 	CALLBACK __export	SendActivate(HWND, LPARAM);
extern	BOOL 	CALLBACK __export	PostPaint(HWND, LPARAM);
extern	BOOL 	CALLBACK __export	DeleteProperty(HWND, LPCSTR, HANDLE);
extern	LRESULT CALLBACK __export	DeliverEnterLeave(int, WPARAM, LPARAM);
extern	void	FAR PASCAL __export	SetHookDeliverEL(HHOOK);

/* cursor.c */
extern void 	NEAR PASCAL	SetDefaultCursor(HCURSOR);
extern HCURSOR 	NEAR PASCAL	GetDefaultCursor(void);
extern HCURSOR 	NEAR PASCAL	FindCursor(HWND);

/* event.c  */
extern XEvent *		NEAR PASCAL	peekEvent(_XQEvent *, XEvent *);
extern _XQEvent *	NEAR PASCAL	discardEvent(_XQEvent *);
extern _XQEvent *	NEAR PASCAL	putEvent(XEvent *, _XQEvent *);

/* instance.c */
extern void		__far __pascal __export	SetAppInstance(HINSTANCE);
extern HINSTANCE	__far __pascal __export	GetAppInstance(void);
extern void		__far __pascal __export	SetTbWindow(HWND);
extern HWND		__far __pascal __export	GetTbWindow(void);
extern void		__far __pascal __export DestroyTerm(void);


/* window.c */
extern unsigned char	NEAR PASCAL	_SetWindowChanges(HWND, unsigned long, XWindowChanges *);
extern unsigned char	NEAR PASCAL	_SetWindowAttributes(HWND, unsigned long, XSetWindowAttributes *);

/* xseterrh.c */
extern void	NEAR PASCAL	postError(unsigned char, unsigned int);

extern void	__far __pascal __export	wputs(const char *, HWND);
extern WPARAM __far __pascal __export main(int, char **);

extern int	msg3event(Display *, MSG *, XEvent *);

extern void	NEAR PASCAL	SetClearProps(HINSTANCE);

