/*
 *	dirent.h
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#ifndef _DIRENT
#define _DIRENT

#include <dos.h>
#include <direct.h>

#define MAXNAMLEN 255

struct dirent {
    short d_namlen;		/* Length of string in d_name */
    char d_name[MAXNAMLEN + 1];	/* Name must be no longer than this */
};

typedef struct _dirdesc {
    int dd_flag;
    struct find_t dd_info;
    struct dirent dd_entry;
} DIR;

extern void	_cdecl	closedir(DIR *dirp);
extern DIR *	_cdecl	opendir(char *name);
extern struct dirent *	_cdecl	readdir(DIR *dirp);

#endif /* _DIRENT */

