# 
#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: setGlobals.t,v 1.11 1994/11/03 05:23:36 andy Exp $
#
# This procedure sets all the necessary globals.
#


proc setGlobals { args } {

    global min
    global hour
    global try
    global phonedb
    global phonelist
    global batchAliasdb
    global batchAliaslist
    global env
    global nlen
    global clen
    global plen
    global resolution
    global popupSequence
    global batch_destinations
    global config_Info

    # Initialize options
    ff_setOptions

    # Hours and minutes to wait until fax is queued for delivery. 
    set min 0
    set hour 0
    set try 0

    # Where to find the local database of fax numbers. FAXNUMBERS is
    # a fully qualified pathname of a file. E.g. "./tkflexfax/faxnumbers"
    if {[info exists env(FAXNUMBERS)]} {
	set phonedb $env(FAXNUMBERS) 
	if {![file exists $phonedb]} {
	    set in [open $phonedb {CREAT WRONLY}]
	    close $in
	}
    } else {
	set phonedb {}
    }

    # Where to find the local database of batch aliases. FAXALIASES is
    # a fully qualified pathname of a file. E.g. "./tkflexfax/faxaliases"
    if {[info exists env(FAXALIASES)]} {
	set batchAliasdb $env(FAXALIASES) 
	if {![file exists $batchAliasdb]} {
	    set in [open $batchAliasdb {CREAT WRONLY}]
	    close $in
	}
    } else {
	set batchAliasdb {}
    }

    # This is so the array size is zero. Anyone know a better way?
    set phonelist(dummy) dummy
    unset phonelist(dummy)

    # This is so the array size is zero. Anyone know a better way?
    set batchAliaslist(dummy) dummy
    unset batchAliaslist(dummy)

    # Set field lengths for display
    set nlen 35
    set plen $config_Info(phoneFieldLen)
    set clen 35

    # Set bindings for pop-up menus
    set popupSequence <B1-ButtonRelease>

    # Set batch destination list
    set batch_destinations {} 
}
