#
# $Id: ff_setOptions.t,v 1.4 1994/11/03 05:23:32 andy Exp $
#
# Initialize options for tkflexfax. Check for $HOME/.tkflexfaxrc file first.
# Then get any command line options.
#

proc ff_setOptions { args } {

    global resolution
    global coverPage
    global initiatePoll
    global notifyOnCompletion
    global notifyOnRetry
    global editorCmd
    global config_Info
    global env

    # Initialize variables
    set tkflexfaxrc {}

    # Default comment lines
    set config_Info(commentLines) 4

    # Default fax phone number field length
    set config_Info(phoneFieldLen) 20

    # Make an empty array
    set ff_Options(dummy) dummy
    unset ff_Options(dummy)

    # Search for options in the .tkflexfaxrc file
    if {[info exists env(HOME)]} {
	set tkflexfaxrc $env(HOME)/.tkflexfaxrc
    } 

    if {[file isfile $tkflexfaxrc] && [file readable $tkflexfaxrc]} {
	ut_ro $tkflexfaxrc ff_Options
    }

    # Collect any command line arguments and override any previous values. 
    foreach name {resolution notifyOnCompletion notifyOnRetry
		  initiatePoll noCoverPage editorCmd} {
	set option [ut_getOption $name]
	if {$option != ""} {
	    set ff_Options($name) $option 
	}
    }

    # Translate user options into flexfax/tkflexfax options.
    foreach name [array names ff_Options] {
	global $name
	switch -exact -- $name resolution {
	    if {$ff_Options($name) == "high"} {
		set $name { -m }
	    } else {
		set $name { -l }
	    }
	} notifyOnCompletion {
	    if {$ff_Options($name) == "yes"} {
		set $name { -D }
	    } else {
		set $name {}
	    }
	} notifyOnRetry {
	    if {$ff_Options($name) == "yes"} {
		set $name { -R }
	    } else {
		set $name {}
	    }
	} initiatePoll {
	    if {$ff_Options($name) == "yes"} {
		set $name { -p }
	    } else {
		set $name {}
	    }
	} noCoverPage {
	    if {$ff_Options($name) == "yes"} {
		set $name { -n }
	    } else {
		set $name {}
	    }
	} editorCmd {
	    set editorCmd $ff_Options($name)
	} commentLines - phoneFieldLen {
	    set config_Info($name) $ff_Options($name) 
	} default {}
    }
}
