#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: ff_sendBatch.t,v 1.2 1994/10/22 22:27:55 andy Exp $
#
# Send all the files to each batch entry.
#

proc ff_sendBatch { w } {

    global batch_destinations 
    global clen
    global nlen

    # Start at the end since we may delete entries
    # in the batch recipients listbox. This list is in the
    # same order as shown in the list box.
    set end [expr [llength $batch_destinations] - 1]
    for {set i $end} {$i >= 0} {incr i -1} {

	set entry [lindex $batch_destinations $i]

	# Extract the name, company and phone from each item. 
	set name [string trim [string range $entry 0 $nlen]]
	ut_updateEntry $w.e_name $name 

	set start [expr $nlen+1]
	set end [expr $nlen+$clen]
	set company [string trim [string range $entry $start $end]]
	ut_updateEntry $w.e_company $company 

	set start [expr $nlen+$clen+1]
	set phone [string trim [string range $entry $start end]] 
	ut_updateEntry $w.e_phone $phone 

	# Force display of current destination
	update idletasks

	# Fax the files
    	faxit .main true

	# Update the batch listbox
	if {[winfo exists .viewbatch]} {
	    .viewbatch.f.bx delete $i
	}

	# Remove this entry in the batch recipients list in case
	# user decides to view batch list. 
	set batch_destinations [lreplace $batch_destinations $i $i] 

    }

    # Reset batch destination list to empty
    set batch_destinations {}
}
