#
#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: ff_mkCover.t,v 1.1 1994/12/31 18:22:00 andy Exp $
#
# Generate fax cover sheet command string.
#


proc ff_mkCover { w } {

    global env

    # Get cover sheet information
    foreach c [winfo children $w] {
	# Get child name
	set cname [winfo name $c]
	# Remove "e_" to get variable name 
	set f [string range $cname 2 end]
	switch -glob -- $f comments* {
	    append comments "[$c get] "
	} default {
	    set $f [string trim [$c get]]
	}
    }

    # Make command.
    append faxcmd "faxcover "

    set comments [string trim $comments]
    if {[string length $comments]} {
	append faxcmd " -c \"$comments\""
    }

    if {[string length $regard]} {
	append faxcmd " -r \"$regard\""
    }

    if {[string length $company]} {
	append faxcmd " -x \"$company\""
    }

    if {[string length $location]} {
	append faxcmd " -l \"$location\""
    }

    if {[string length $name]} {
	append faxcmd " -t \"$name\""  
    } else {
	append faxcmd " -t \"Unknown\""  
    }

    if {[string length $phone]} {
	append faxcmd " -n \"$phone\""
    } else {
	append faxcmd " -n \"Unknown\""
    }

    if {[info exists env(USER)]} {
	append faxcmd " -f \"$env(USER)\""
    } else {
	append faxcmd " -f \"Unknown\""
    }

    return $faxcmd
}
