set dl_config(dl_ext_name) ".so"
set dl_config(dl_library_names) ""
set dl_config(dl_init_flag) 0
set dl_config(dl_host_name) "sunos4"

proc dl_use module {
    global env
    global argv0
    global dl_config

    if { $dl_config(dl_init_flag) == 0 } {
	dl_use_init $argv0
	set dl_cofig(dl_init_flag) 1
    }
    if { [info exist env(DL_LIBRARY)] == 1 } {
	set dl_path $env(DL_LIBRARY)
	while { [string length $dl_path] > 0 } {
	   set pos [string first ":" $dl_path] 
	   if { $pos == 0 } {
		set dl_path [string range $dl_path [expr $pos + 1] end] 
		continue
	   } else {
		if { $pos == -1 } {
		   set newdir $dl_path
		} else {
		   set newdir [string range $dl_path 0 [expr $pos - 1]]
		} 		
		set newfile [format "%s/%s.tcl" $newdir $module]
#puts "=> $newfile"
		if { [file exists $newfile] } {
		   source $newfile
		}

		set newfile [format "%s/%s/%s_default" $newdir $dl_config(dl_host_name) $module]
		if { [file exists $newfile] } {
		   source $newfile
		}
		if { $pos == -1 } {
		   break;
		}
		set dl_path [string range $dl_path [expr $pos + 1] end] 
	   }
	}
	dl_use_$module
    } else {
	error "Perhaps you need to set your DL_LIBRARY environment variable?\n"
	return
    }
}

proc dl_destroy module {
    dl_destroy_$module
}
