#include <tcl.h>
#include "dl_tcl.h"

int
Dl_Init(interp)
Tcl_Interp *interp;
{
    static char initCmd[] =
    "if { [info exist env(DL_LIBRARY)] == 1 } {\
        set dl_path $env(DL_LIBRARY)\n\
        while { [string length $dl_path] > 0 } {\
	   set pos [string first \":\" $dl_path]\n\
	   if { $pos == 0 } {\
	      set dl_path [string range $dl_path [expr $pos + 1] end]\n\
	      continue\n\
	   } else {\
	      if { $pos == -1 } { set newdir $dl_path }\
	      else { set newdir [string range $dl_path 0 [expr $pos - 1]] }\n\
	      set newfile [format \"%s/dl_use.tcl\" $newdir]\n\
	      if { [file exists $newfile] } { source $newfile; }\n\
	      if { $pos == -1 } {\
		 unset pos newdir newfile dl_path\n\
		 break;\n\
	      }\n\
	      set dl_path [string range $dl_path [expr $pos + 1] end]\n\
	   }\n\
        }\n\
     } else { error \"Perhaps you need to set your DL_LIBRARY environment variable?\n\" }";

     Tcl_CreateCommand(interp, "dl_use_init", Dl_UseInit, 
     	(ClientData *) NULL, (Tcl_CmdDeleteProc *)NULL);
     Tcl_CreateCommand(interp, "dl_exec_module", Dl_ExecModule, 
     	(ClientData *) NULL, (Tcl_CmdDeleteProc *)NULL);
     Tcl_CreateCommand(interp, "dl_destroy_module", Dl_DestroyModule, 
     	(ClientData *) NULL, (Tcl_CmdDeleteProc *)NULL);
    return Tcl_GlobalEval (interp, initCmd);
}
