/* dl_dlopen.c
 *    Created 14/3/95, Xiaokun Zhu <xiaokun@aero.gla.ac.uk>
 *    Modified 20/03/95, Xiaokun Zhu
 *      function Dl_ExecModule only output one variable dl_module_address and
 *	don't need input variable dl_exit_name.
 *      funciont Dl_DestroyModule take two input variables: dl_module_address
 *      and dl_exit_name.
 */

#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <tcl.h>
#include <dl_tcl.h>

#include "dl_misc.c"

/*
 * Dl_UseInit
 *
 * argv[1] -- in
 *  program name, for example, tclsh
 */
int
Dl_UseInit(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
    static char ld_library_path[256];
    char *p;
    char *dl_library;
    
    if (argc != 2) {
	interp->result = "wrong # args";
	return TCL_ERROR;
    }
    strcpy(ld_library_path, "LD_LIBRARY_PATH=");
    p = getenv("LD_LIBRARY_PATH");
    strcat(ld_library_path, p);
    if ((dl_library = getenv("DL_LIBRARY")) == NULL) {
       interp->result = "Perhaps you need to set your DL_LIBRARY environment variable?";
       return TCL_ERROR;               
    }
    strcat(ld_library_path, ":");
    strcat(ld_library_path, dl_library);
    if (putenv(ld_library_path)) {
       interp->result = "wrong: unable to set new LD_LIBRARY_PATH environment variable!";
       return TCL_ERROR;               
    }
    p = getenv("LD_LIBRARY_PATH");
    DP(fprintf(stderr,"New LD_LIBRARY_PATH: %s\n",p));
    return TCL_OK;
}

/*
 * Dl_DestroyModule
 *
 * argv[1] -- in
 *  Tcl array variable XXX_config, which uses
 *	dl_entry_name 	  -- in
 *	dl_exit_name  	  -- in
 *	dl_module_address -- in
 */
int
Dl_DestroyModule(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
    char *dl_module_address;
    char *dl_exit_name;
    void * exit_ref;
    void * module_handle;
    int dl_err;
    
    if (argc != 2) {
	interp->result = "wrong # args";
	return TCL_ERROR;
    }
    if ((dl_module_address=Tcl_GetVar2(interp, argv[1], "dl_module_address", 
	    TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY)) == NULL )
        return TCL_ERROR;
    if ((dl_exit_name=Tcl_GetVar2(interp, argv[1], "dl_exit_name",
            TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY)) == NULL )
        return TCL_ERROR;
    DP(fprintf(stderr, "dl_exit_name: %s\n", dl_exit_name));
        	
    { void * module_value;
      sscanf(dl_module_address,"%lx", &module_value);
      module_handle = (void *)module_value;
      DP(fprintf(stderr,"module_handle = %lx\n", module_handle));
    }         
    
   { void * exit_ref;
     char exitname[256];
     char address[20];
       
#ifdef ADD_UNDERSCORE
     strcpy(exitname, "_");
#else
     exitname[0] = '\0';
#endif
     strcat(exitname, dl_exit_name);
     DP(fprintf(stderr, "exitname: %s\n", exitname));
     if ((exit_ref = dlsym(module_handle, exitname)) == NULL) {
        sprintf(interp->result, "wrong: unable to find <%s> symbol: %s", exitname, dlerror());
        return TCL_ERROR;
     }
     DP(fprintf(stderr,"exit_ref = %lx\n", exit_ref));
     if ((* (int (*)()) exit_ref)(interp) == TCL_ERROR)
  	 return TCL_ERROR;
   }    
   DP(fprintf(stderr,"dlclose(%lx)\n",module_handle));
   if (dl_err=dlclose(module_handle)) {
       sprintf(interp->result,"wrong: dlclose(%lx): %s\n",module_handle, dlerror());
       return TCL_ERROR;
      }
    return TCL_OK;
}

/* Dl_ExecModule
 *
 * argv[1] -- in/out
 *  Tcl array variable XXX_config, which uses 
 *	dl_module_name 	 -- in
 * 	dl_library_names -- in
 *	dl_entry_name	 -- in
 *	dl_module_address -- out
 */
int
Dl_ExecModule(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
    char *dl_module_name;
    char *dl_library_path;
    char *dl_library_names;
    char *dl_entry_name;

    char *filename;
    void *module_handle;
    int dl_err;
    int mode=1;
    
#ifdef RTLD_LAZY
    mode = RTLD_LAZY; /* Solaris 2 */
#endif
    if (argc != 2) {
	interp->result = "wrong # args";
	return TCL_ERROR;
    }	    
    if ((dl_module_name=Tcl_GetVar2(interp, argv[1], "dl_module_name", 
	    TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY)) == NULL )
        return TCL_ERROR;
    if ((dl_library_names=Tcl_GetVar2(interp, argv[1], "dl_library_names", 
	    TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY)) == NULL )
        return TCL_ERROR;
    if ((dl_entry_name=Tcl_GetVar2(interp, argv[1], "dl_entry_name",
            TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY)) == NULL )
        return TCL_ERROR;
    if ((dl_library_path = getenv("DL_LIBRARY")) == NULL) {
       interp->result = "Perhaps you need to set your DL_LIBRARY environment variable?";
       return TCL_ERROR;               
    }
    DP(fprintf(stderr,"dl_module_name: %s \n", dl_module_name));
    DP(fprintf(stderr, "dl_library_names: %s\n", dl_library_names));
    DP(fprintf(stderr, "dl_entry_name: %s\n", dl_entry_name));
    DP(fprintf(stderr, "dl_library_path: %s\n", dl_library_path));

    if ((filename = dl_find_file(dl_module_name, dl_library_path)) == NULL) {
       sprintf(interp->result,"wrong: dl_find_file(%s)", dl_module_name);
       return TCL_ERROR; 
    }   
    DP(fprintf(stderr, "dl_find_file(%s): \n", dl_module_name, filename));

    if ( (module_handle = dlopen(filename, mode)) == NULL) {
       sprintf(interp->result,"wrong: No module <%s> %s", filename, dlerror());
       free(filename);
       return TCL_ERROR; 
    }
    DP(fprintf(stderr, "dlopen(%s, %d)\n", filename, mode));
    free (filename);

    { char address[20];
	/* create TCL variable XXX_config(dl_module_address) */
      sprintf(address,"%lx",module_handle);
      DP(fprintf(stderr,"module_handle: %lx\n",module_handle));
      if (Tcl_SetVar2(interp, argv[1], "dl_module_address", address, 
	 TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY) == NULL)
	 return TCL_ERROR;
    }


   { void * boot_ref;
     char bootname[256];
     int ret_v;
     
#ifdef ADD_UNDERSCORE
     strcpy(bootname, "_");
#else
     bootname[0] = '\0';
#endif
     strcat(bootname, dl_entry_name);
     DP(fprintf(stderr, "bootname: %s\n", bootname));
     if ((boot_ref = dlsym(module_handle, bootname)) == NULL) {
        sprintf(interp->result, "wrong: unable to find <%s> symbol: %s", bootname, dlerror());
        return TCL_ERROR;
     }
     DP(fprintf(stderr,"boot_ref = %lx\n", boot_ref));

     ret_v = (* (int (*)()) boot_ref)(interp);
     return ret_v;
   }    
} 
