/* dl_dld.c
 *    Created 7/3/95, Xiaokun Zhu <xiaokun@aero.gla.ac.uk>
 *    Modified 14/3/95, Xiaokun Zhu
 *	discarded functions dl_load_file, dl_undef_symbols, dl_find_symbol.
 *	rewrote function Dl_ExecModule.
 *      created function Dl_DestroyModule.
 *    Modified 20/03/95, Xiaokun Zhu
 *      function Dl_ExecModule only output one variable dl_module_address and
 *	don't need input variable dl_exit_name.
 *      funciont Dl_DestroyModule take two input variables: dl_module_address
 *      and dl_exit_name.
 */
 
#include <stdlib.h>
#include <strings.h>
#include <dld.h>
#include <tcl.h>
#include <dl_tcl.h>

#include "dl_misc.c"

/*
 * Dl_UseInit
 *
 * argv[1] -- in
 *  program name, for example, tclsh
 */
int
Dl_UseInit(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
    int dl_err;
    if (argc != 2) {
	interp->result = "wrong # args";
	return TCL_ERROR;
    }
    DP(fprintf(stderr,"%s\n", argv[1]));
    if (dl_err=dld_init(dld_find_executable(argv[1]))) {
            sprintf(interp->result,"dl_use_init failed: <%s> ",
            		argv[1], dld_strerror(dl_err));
            return TCL_ERROR;
    }
    return TCL_OK;
}

/*
 * Dl_DestroyModule
 *
 * argv[1] -- in
 *  Tcl array variable XXX_config, which uses
 *	dl_entry_name 	  -- in
 *	dl_exit_name  	  -- in
 *	dl_module_address -- in
 */
int
Dl_DestroyModule(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
    char *dl_module_address;
    char *dl_entry_name;
    char *dl_exit_name;
    void *exit_ref;
    unsigned exit_value;
    int dl_err;
    
    if (argc != 2) {
	interp->result = "wrong # args";
	return TCL_ERROR;
    }
    if ((dl_module_address=Tcl_GetVar2(interp, argv[1], "dl_module_address", 
	    TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY)) == NULL )
        return TCL_ERROR;
    if ((dl_entry_name=Tcl_GetVar2(interp, argv[1], "dl_entry_name",
            TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY)) == NULL )
        return TCL_ERROR;
    if ((dl_exit_name=Tcl_GetVar2(interp, argv[1], "dl_exit_name",
            TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY)) == NULL )
        return TCL_ERROR;
    DP(fprintf(stderr, "dl_module_address: %s\n", dl_module_address));
    DP(fprintf(stderr, "dl_exit_name: %s\n", dl_exit_name));
    
    { int len=strlen(dl_module_address);
    if (dl_module_address[len-1] == 'a') {
      DP(fprintf(stderr, "dld_create_ref(%s)\n", dl_exit_name));
      if (dl_err = dld_create_reference(dl_exit_name)) {
        sprintf(interp->result, "dld_create_reference(%s): %s", dl_exit_name, dld_strerror(dl_err));
	return TCL_ERROR;
      }                                                                  
      if (dl_err = dld_link(dl_module_address)) {
       sprintf(interp->result,"wrong: No module <%s> %s", dl_module_address, dld_strerror(dl_err));
       return TCL_ERROR; 
      }
      DP(fprintf(stderr, "dld_link(%s)\n", dl_module_address));
     }
    }
     DP(fprintf(stderr, "exitname: %s\n", dl_exit_name));
     if ((exit_ref = (void *)dld_get_func(dl_exit_name)) == NULL) {
        sprintf(interp->result, "wrong: unable to find <%s> symbol", dl_exit_name);
        return TCL_ERROR;
     }
     if (dld_function_executable_p (dl_exit_name)) {
        DP(fprintf(stderr,"exit_ref = %lx\n", exit_ref));
        if ((* (int (*)()) exit_ref)(interp) == TCL_ERROR)
 	   return TCL_ERROR;
     } else {
        sprintf(interp->result, "func: %s not executable!\n", dl_exit_name);
        DP(fprintf(stderr,"func: %s not executable!\n", dl_exit_name));
        return TCL_ERROR;
     }
	
    DP(fprintf(stderr,"dld_unlink_by_symbol(%s)\n",dl_entry_name)); 
    if (dl_err=dld_unlink_by_symbol(dl_entry_name, 0)) {
	sprintf(interp->result,"wrong: dld_unlink_by_symbol(%s): %s\n",dl_entry_name, dld_strerror(dl_err));
	return TCL_ERROR;
    }         
    DP(fprintf(stderr,"dld_unlink_by_symbol(%s)\n",dl_exit_name)); 
    if (dl_err=dld_unlink_by_symbol(dl_exit_name, 0)) {
	sprintf(interp->result,"wrong: dld_unlink_by_symbol(%s): %s\n",dl_exit_name, dld_strerror(dl_err));
	return TCL_ERROR;
    }         
    return TCL_OK;
}

/* Dl_ExecModule
 *
 * argv[1] -- in/out
 *  Tcl array variable XXX_config, which uses 
 *	dl_module_name 	 -- in
 * 	dl_library_names -- in
 *	dl_entry_name	 -- in
 *	dl_module_address -- out
 */
int
Dl_ExecModule(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
    char *dl_module_name;
    char *dl_library_path;
    char *dl_library_names;
    char *dl_entry_name;

    char *filename;
    int dl_err;
    
    if (argc != 2) {
	interp->result = "wrong # args";
	return TCL_ERROR;
    }	    

    if ((dl_module_name=Tcl_GetVar2(interp, argv[1], "dl_module_name", 
	    TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY)) == NULL )
        return TCL_ERROR;
    if ((dl_library_names=Tcl_GetVar2(interp, argv[1], "dl_library_names", 
	    TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY)) == NULL )
        return TCL_ERROR;
    if ((dl_entry_name=Tcl_GetVar2(interp, argv[1], "dl_entry_name",
            TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY)) == NULL )
        return TCL_ERROR;
    if ((dl_library_path = getenv("DL_LIBRARY")) == NULL) {
       interp->result = "Perhaps you need to set your DL_LIBRARY environment variable?";
       return TCL_ERROR;
    }
    DP(fprintf(stderr,"dl_module_name: %s \n", dl_module_name));
    DP(fprintf(stderr, "dl_library_names: %s\n", dl_library_names));
    DP(fprintf(stderr, "dl_entry_name: %s\n", dl_entry_name));
    DP(fprintf(stderr, "dl_library_path: %s\n", dl_library_path));

    DP(fprintf(stderr, "dld_create_ref(%s)\n", dl_entry_name));
    if (dl_err = dld_create_reference(dl_entry_name)) {
        sprintf(interp->result, "dld_create_reference(%s): %s", dl_entry_name, dld_strerror(dl_err));
	return TCL_ERROR;
    }                                                                  
    if ((filename = dl_find_file(dl_module_name, dl_library_path)) == NULL) {
       sprintf(interp->result,"wrong: dl_find_file(%s)", dl_module_name);
       return TCL_ERROR; 
    }   
    DP(fprintf(stderr, "dl_find_file(%s): %s\n", dl_module_name, filename));

	/* create TCL variable XXX_config(dl_module_address) */
    if (Tcl_SetVar2(interp, argv[1], "dl_module_address", filename, 
	TCL_LEAVE_ERR_MSG|TCL_GLOBAL_ONLY) == NULL)
	return TCL_ERROR;
    
    if (dl_err = dld_link(filename)) {
       sprintf(interp->result,"wrong: No module <%s> %s", filename, dld_strerror(dl_err));
       return TCL_ERROR; 
    }
    DP(fprintf(stderr, "dld_link(%s)\n", filename));
    free (filename);
    
    if (dld_undefined_sym_count) 
    { char *library;          /* link others library if required */
      while (*dl_library_names && *dl_library_names == ' ')
     	dl_library_names++;
      while ( (library=get_word(&dl_library_names)) != NULL ) {
        DP(fprintf(stderr, "get_word(%s)\n", library));
        if ((filename = dl_find_file(library, dl_library_path)) == NULL ) {
           sprintf(interp->result,"wrong: dl_find_file(%s)", library);
           return TCL_ERROR; 
    	}
        DP(fprintf(stderr, "dld_link(%s)\n", filename));
	if (dl_err = dld_link(filename)) {
            sprintf(interp->result,"wrong: dl_link(%s): %s", filename, dld_strerror(dl_err));
	    free (filename);
	    return TCL_ERROR; 
	}
	free (filename);
     }	
   }

   { char ** undef_syms;
     if (dld_undefined_sym_count)
	if (undef_syms = dld_list_undefined_sym()) {
           sprintf(interp->result, "Undefined symbols: %s\n", *undef_syms);
           DP(fprintf(stderr, "Undefined symbols: %s\n", *undef_syms));
	   free(undef_syms);
     	   return TCL_ERROR;
        }
   }

   
   { void * boot_ref;
     int ret_v;
     
     DP(fprintf(stderr, "bootname: %s\n", dl_entry_name));
     if ((boot_ref = (void *)dld_get_func(dl_entry_name)) == NULL) {
        sprintf(interp->result, "wrong: unable to find <%s> symbol", dl_entry_name);
        return TCL_ERROR;
     }
     if (dld_function_executable_p (dl_entry_name)) {
        DP(fprintf(stderr,"boot_ref = %lx\n", boot_ref));
	ret_v = (* (int (*)()) boot_ref)(interp);
        return ret_v;
     } else {
        sprintf(interp->result, "func: %s not executable!\n", dl_entry_name);
        return TCL_ERROR;
     }        
   }    
} 
  	