#------------------------------------------------
# ---- DateStuff.tcl 
# ----    Some simple date manipulation functions
#------------------------------------------------

# ---- Set up some globals
set monthdays {31 28 31 30 31 30 31 31 30 31 30 31}
set lydays {31 29 31 30 31 30 31 31 30 31 30 31}
set months {Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec}
set weekdays {Sun Mon Tues Wed Thu Fri Sat}

#startref is the start date of any random payday.
set startref "Jan 8 1995"
set date1 [exec date]
scan $date1 "%s %s %s %s %s %s" date(dow) date(month) date(day) \
                                junk junk date(year)

# ---- isBetween {date date1 date2}
# ----	check to see if date is between date1 and date2
proc isBetween {d d1 d2} {
 set date [to-julian $d]
 set date1 [to-julian $d1]
 set date2 [to-julian $d2]
 set y [lindex $d 2]
 set y1 [lindex $d1 2]
 set y2 [lindex $d2 2]
 set date [expr $y*1000 + $date]
 set date1 [expr $y1*1000 + $date1]
 set date2 [expr $y2*1000 + $date2]
 if {[expr ($date1 <= $date)&&($date<=$date2)]} {
  return 1
 }
 return 0
}

# ---- isLeapYear {year} 
# ---- test to see if it's a leap year.  Duh!
proc isLeapYear { year } {
 set test [expr $year>>2]
 set test2 [expr $test<<2]
 if {$test2==$year} {
  return 1
 }
 return 0
}

# ---- to-julian { gregorian }
proc to-julian { gregorian } {
 global date monthdays months lydays
 set mdays $monthdays
 set gregdate [split $gregorian]
 set ty [lindex $gregorian 2]
 if {[isLeapYear $ty]} {
  set mdays $lydays
 }
 set i 0
 set juldate [lindex $gregorian 1]
 set tm [lindex $gregorian 0]
 set jb [lindex $months 0]
 while {$tm != $jb} {
  set ndays [lindex $mdays $i]
  set juldate [expr $juldate + $ndays]
  incr i 1
  set jb [eval {lindex $months $i}]
 }
 return $juldate
}

proc to-gregorian { julian year } {
 global monthdays lydays months
 set mdays $monthdays
 set limit 365
 if {[isLeapYear $year]} {
  set mdays $lydays
  set limit 366
 }
 if {$julian > $limit} {
  set julian [expr $julian - $limit]
  incr year
 }
 set tjul $julian
 set tmon 31
 set i 0
 while {$tjul>$tmon} {
  set tjul [expr $tjul - $tmon]
  incr i 1
  set tmon [lindex $mdays $i]
 }
 set m [lindex $months $i]
 set gregdate "$m $tjul $year"
 return $gregdate
}

proc tomorrow { gregorian } {
 set gregdate [split $gregorian]
 set ty [lindex $gregdate 2]
 set td [to-julian $gregorian]
 incr td 1
 set gregdate [to-gregorian $td $ty]
 return $gregdate
}

proc is-greater { one two } {
 set onejulian [to-julian $one]
 set onetotal [expr 1000 * [lindex $one 2] + [to-julian $one]]
 set twototal [expr 1000 * [lindex $two 2] + [to-julian $two]]
 if {$onetotal >= $twototal} {
  return 1
 }
 return 0
}

proc paystart { gregorian } {
 global startref
 set tempref $startref
 set gooddate $startref
 set sr [to-julian $startref]
 while {[is-greater $gregorian $tempref]} {
  incr sr 14
  set gooddate $tempref
  set tempref [to-gregorian $sr [lindex $tempref 2]]
  if {$sr > 364} {
   set sr [to-julian $tempref]
  }
 }
return $gooddate
}

