# install as ~/.tk/jeditrc.tcl - user customisation file for jedit
# * sets each window's icon to a miniature picture of the window and
#   its contents
# * explicitly positions each jedit window based on how many jedit
#   applications are running and how many windows this one has open
######################################################################

######################################################################
# additions to GUI:

proc jedit:userhook { window } {
  set t [jedit:top_to_text $window]	;# relevant text widget
  ######################################################################
  # window icon:
  
  if {[winfo class $window] == "Toplevel"} {
    catch {
      global jed_icons
      
      if ![info exists jed_icons] {
        set jed_icons 0
      } else {
        incr jed_icons
      }
      
      wm withdraw $window
      
      set icon [j:new_toplevel .icon]
      j:tk3 {$icon configure -geometry 48x48}
      j:tk4 {$icon configure -width 48 -height 48}
      wm withdraw $icon
      frame $icon.menu -borderwidth 1 -width 48 -height 6 -relief raised
      frame $icon.label -borderwidth 0 -width 48 -height 4 -relief flat
      text $icon.text \
        -background white -borderwidth 1 -wrap none
      catch {$icon.text configure -highlightthickness 1}
      catch {$icon.text configure -font nil2}
      scrollbar $icon.sb -borderwidth 1 -width 6
      catch {$icon.sb configure -highlightthickness 1}
      pack $icon.menu
      pack $icon.label
      pack $icon.sb -side right -fill y
      pack $icon.text -side left -fill both -expand y
      
      update idletasks
      
      wm iconwindow $window $icon
      wm geometry $icon 48x48
      
      foreach w [list $icon $icon.menu $icon.label $icon.text $icon.sb] {
        foreach button {1 2 3 4 5} {
          bind $w <Any-ButtonPress-$button> { }
          bind $w <Any-ButtonPress-$button> "wm deiconify $window"
        }
      }
    }
    update
    
    bind [winfo toplevel $t] <Unmap> [format {
      catch {
        %s.text delete 1.0 end
        %s.text insert end [%s get 1.0 40.0]
      }
    } $icon $icon $t]
    
    bind $t <Destroy> [list catch [list destroy $icon]]
    
    wm deiconify $window
  }
}
