# jprefpanel.tcl - preference panel(s) and related tools
#
######################################################################
# Copyright 1992-1996 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

######################################################################
# global variables:
#
global J_PREFS env
j:default J_PREFS(autoposition) 0
j:default J_PREFS(confirm) 1
#
######################################################################

######################################################################
# Localisation defaults:
#
j:ldb:set_defaults {
  {prefs:done {Done}}
  {prefs:save {Save}}
  {title:prefs {Global Preferences}}
  {prefs:language {Language:}}
  {prefs:autoposition {Autoposition dialogue boxes}}
  {prefs:confirm {Confirm actions}}
  {prefs:j_fs_fast {Fast file selector}}
  {prefs:tk_strictMotif {Strict Motif emulation}}
  {prefs:scrollbarside {Scrollbars on left}}
  {prefs:visiblebell {Visible bell}}
  {prefs:audiblebell {Audible bell}}
  {{Keyboard Bindings:} {Keyboard Bindings:}}
  {prefs:basic {Basic bindings}}
  {prefs:vi {vi bindings}}
  {prefs:edt {EDT bindings}}
  {prefs:emacs {Emacs bindings}}
  {prefs:typeover {Typing replaces selection}}
  {{Web Browser:} {Web Browser:}}
  {prefs:mosaic {Mosaic}}
  {prefs:netscape {Netscape}}
  {prefs:arena {arena}}
  {prefs:lynx {lynx in an xterm}}
  {{Man Page Viewer:} {Man Page Viewer:}}
  {prefs:man_builtin {builtin}}
  {prefs:man_tkman {TkMan}}
  {prefs:man_man {man(1) in an xterm}}
  {prefs:printer {Printer:}}
  {title:prompt {Prompt}}
  {{Enter a value:} {Enter a value:}}
  {{Font:} {Font:}}
  {prompt:tcl {Tcl Command:}}
  {title:tcl:result_short {Tcl result}}
  {title:tcl:result {Result of Tcl command}}
  {prompt:unix {Unix Command:}}
  {title:unix:result_short {Command output}}
  {title:unix:result {format "Output of $command"}}
  {prompt:colour_name {Choose a colour:}}
  {title:colour_name {Colour Name Selector}}
  {prompt:colour_rgb {Choose a colour:}}
  {title:colour_rgb {RGB Colour Selector}}
}

######################################################################
# j:global_pref_panel ?options? - preferences panel for ~/.tk/defaults
# options include
#   -title - title of toplevel window
### ADD COLOURS?
######################################################################

proc j:global_pref_panel { args } {
  j:pref:show_panel .global_prefs
}

######################################################################
######################################################################

######################################################################
# j:pref:string_ui w ?options? - labelled UI for global variable
# BOGUSNESS:  you need to know that the entry is $newframe.e
#   in order to bind to it!
######################################################################

proc j:pref:string_ui {args} {
  j:parse_args {
    {label {Value:} }
    {variable value }
    {labelwidth {30} }
    {entrywidth {40} }
  }
  global $variable
  
  set label [uplevel 1 [list j:ldb $label]]
  
  set newframe [lindex $args 0]
  
  frame $newframe
  set l $newframe.l
  set e $newframe.e
  label $l -text $label -width $labelwidth -anchor e
  entry $e -width $entrywidth -textvariable $variable
  
  pack $l -in $newframe -side left
  pack $e -in $newframe -side left -fill x
  
  return $newframe
}

######################################################################
# j:pref:boolean_ui w ?options? - labelled UI for global variable
######################################################################

proc j:pref:boolean_ui {args} {
  j:parse_args {
    {label {Value:} }
    {variable value }
    {labelwidth {30} }
    {buttonwidth {40} }
  }
  global $variable
  
  set label [uplevel 1 [list j:ldb $label]]
  
  set newframe [lindex $args 0]
  
  frame $newframe
  set l $newframe.l
  set cb $newframe.cb
  label $l -text $label -width $labelwidth -anchor e
  checkbutton $cb \
    -variable $variable -width $buttonwidth -anchor w -text " "
  
  pack $l -in $newframe -side left
  pack $cb -in $newframe -side left -fill x
  
  return $newframe
}

######################################################################
# j:pref:radio_ui w ?options? - labelled UI for global variable
######################################################################

proc j:pref:radio_ui {args} {
  j:parse_args {
    {label {Value:} }
    {variable value }
    {labelwidth {30} }
    {buttonwidth {40} }
    {values {{1 this} {2 that} {3 {the other}}}}
  }
  global $variable
  
  set label [uplevel 1 [list j:ldb $label]]
  
  set newframe [lindex $args 0]
  frame $newframe
  foreach valuepair $values {
    set value [lindex $valuepair 0]
    set text [lindex $valuepair 1]
    set f $newframe.f$value
    set l $f.l
    set rb $f.rb
    frame $f
    label $l -text $label -width $labelwidth -anchor e
    radiobutton $rb \
      -variable $variable -text $text \
      -width $buttonwidth -anchor w -value $value
    
    pack $l -in $f -side left
    pack $rb -in $f -side left -fill x
    
    pack $f -in $newframe -side top -fill x
    set label " "			;# so only first line is labelled
  }
  
  return $newframe
}

######################################################################
# j:pref:colour_ui w ?options? - labelled UI for global variable
######################################################################

proc j:pref:colour_ui {args} {
  j:parse_args {
    {label {Colour:} }
    {variable value }
  }
  # need to support following:
  #  {labelwidth {30} }
  #  {buttonwidth {40} }
  
  global $variable
  
  set label [uplevel 1 [list j:ldb $label]]
  
  set newframe [lindex $args 0]
  j:colour_chooser $newframe -label $label -variable $variable
  return $newframe
}

proc j:pref:color_ui {args} [info body j:pref:colour_ui]

######################################################################
# j:pref:show_module module - cause panel to show prefs for module
######################################################################

proc j:pref:show_module { module } {
  global JPREF_INFO
  
  set w $JPREF_INFO(panel,$module)
  if {![winfo exists $w]} {
    j:pref:create_panel $w
  }
  catch {destroy $w.mid.module}
  j:pref:module_ui $w.mid.module $module
  place $w.mid.module -in $w.mid -relx 0.5 -rely 0.5 -anchor c
}

######################################################################
# j:pref:module_ui w module - create pref panel for module
######################################################################

proc j:pref:module_ui { w module } {
  global JPREF_PREFS JPREF_INFO
  
  frame $w
  label $w.l -text $JPREF_INFO(module_name,$module)
  pack $w.l [j:filler $w] -fill x
  set count 0
  foreach pref $JPREF_PREFS($module) {
    set array $JPREF_INFO(array,$module)	;# name of array for module
    set element [set array]($pref)		;# array element this pref sets
    switch -exact $JPREF_INFO(type,$pref) {
      string {
        j:pref:string_ui $w.pref$count \
          -label $JPREF_INFO(prompt,$pref) \
          -variable $element
        pack $w.pref$count -in $w -side top -fill x -anchor w -expand 1
      }
      boolean {
        j:pref:boolean_ui $w.pref$count \
          -label $JPREF_INFO(prompt,$pref) \
          -variable $element
        pack $w.pref$count -in $w -side top -fill x -anchor w -expand 1
      }
      radio {
        j:pref:radio_ui $w.pref$count \
          -label $JPREF_INFO(prompt,$pref) \
          -values $JPREF_INFO(values,$pref) \
          -variable $element
        pack $w.pref$count -in $w -side top -fill x -anchor w -expand 1
      }
      colour {
        j:pref:colour_ui $w.pref$count \
          -label $JPREF_INFO(prompt,$pref) \
          -variable $element
        pack $w.pref$count -in $w -side top -fill x -anchor w -expand 1
      }
      color {
        j:pref:colour_ui $w.pref$count \
          -label $JPREF_INFO(prompt,$pref) \
          -variable $element
        pack $w.pref$count -in $w -side top -fill x -anchor w -expand 1
      }
      default {
        # default to handling as a string preference:
        j:pref:string_ui $w.pref$count \
          -label $JPREF_INFO(prompt,$pref) \
          -variable $element
        pack $w.pref$count -in $w -side top -fill x -anchor w -expand 1
      }
    }
    incr count
  }
  return $w
}

######################################################################
# j:pref:create_panel w - create pref panel
######################################################################

proc j:pref:create_panel { panel } {
  global JPREF_MODULES JPREF_INFO
  
  catch {destroy $panel}		;# make sure it doesn't already exist
  
  toplevel $panel
  set count 0
  pack [frame $panel.top] -fill x
  foreach module $JPREF_MODULES($panel) {
    pack [button $panel.top.$module] -side left
    $panel.top.$module configure \
      -text $JPREF_INFO(module_name,$module) \
      -command [list j:pref:show_module $module]
  }
  pack [j:rule $panel] -fill x
  pack [frame $panel.mid -width 500 -height 300]	;######### DON'T HARDCODE
  pack propagate $panel.mid 0
  pack [j:rule $panel] -fill x
  
  j:buttonbar $panel.b -default save -buttons [format {
    {
      save prefs:save {
        j:write_prefs;			######### NEED TO SAVE ALL VARIABLES
        destroy %s
      }
    } {
      done prefs:done {
        destroy %s
      }
    }
  } $panel $panel]
  pack $panel.b -side right
  j:dialogue $panel			;# position nicely
}

######################################################################
# j:pref:show_panel w - create w if necessary and show first module
######################################################################

proc j:pref:show_panel { panel } {
  global JPREF_MODULES JPREF_INFO
  
  j:pref:create_panel $panel

  set old_focus [focus]			;# so we can restore original focus
  set module \
    [lindex $JPREF_MODULES($panel) 0]	;# find first pref module in panel
  j:pref:show_module $module		;# display module
  grab $panel
  tkwait window $panel
  j:tk3 {focus $old_focus}
  j:tk4 {focus -force $old_focus}	;# can't figure out a better way...
}
