# ~/.tk/edittkmodes/richtext-mode.tcl - mode for styled text
######################################################################

j:ldb:set_defaults {
  {{(new file)} {(new file)}}
  
  {{Help on richtext Mode} {Help on `richtext' Mode}}
}

proc mode:richtext:init { t } {
  global JEDIT_MODEPREFS
  
  j:read_prefs -array JEDIT_MODEPREFS -prefix richtext \
    -directory ~/.tk/jeditmodes -file richtext-defaults {
    {textfont default}
    {textwidth 80}
    {textheight 24}
    {textwrap word}
    {sabbrev 0}
    {dabbrev 0}
    {autobreak 0}
    {autoindent 0}
    {savestate 0}
    {buttonbar 1}
    {buttons {
      jedit:cmd:done
      jedit:cmd:save
      jedit:cmd:print_postscript
    }}
    {docs {
      -
      {{Help on richtext Mode} {jeditmodes/richtext-mode.jdoc}}
    }}
    {menu,editor 1}
    {menu,file 1}
    {menu,edit 1}
    {menu,prefs 0}
    {menu,abbrev 1}
    {menu,filter 1}
    {menu,format 1}
    {menu,display 1}
    {menu,mode1 0}
    {menu,mode2 0}
    {menu,user 1}
  }
}

######################################################################
# save entire contents of text widget, including tags and marks
#   (overrides normal write procedure)
######################################################################

proc mode:richtext:write { filename t } {
  j:tag:archive_text_widget $t $filename
}

######################################################################
# read in archive of text widget, including tags and marks
#   (overrides normal read procedure)
######################################################################

proc mode:richtext:read { filename t } {
  jedit:font:roman $t				;# start tagging as roman
  if { ! [file exists $filename] } then {
    $t delete 1.0 end
    $t mark set insert 1.0
    jedit:set_label $t "$filename [j:ldb {(new file)}]"
  } else {					;# file exists
    j:tag:restore_text_widget $t $filename
    global JEDIT_MODEPREFS
    if { ! $JEDIT_MODEPREFS(richtext,savestate) } {
      $t tag remove sel 1.0 end
      $t mark set insert 1.0
      $t yview 1.0
    }
  }
}




